/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.builtin.hardware.ComputerSystem;
import org.aoju.bus.health.builtin.hardware.GlobalMemory;
import org.aoju.bus.health.builtin.hardware.HardwareAbstractionLayer;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.health.builtin.hardware.Sensors;

@ThreadSafe
public abstract class AbstractHardwareAbstractionLayer
implements HardwareAbstractionLayer {
    private final Supplier<ComputerSystem> computerSystem = Memoize.memoize(this::createComputerSystem);
    private final Supplier<CentralProcessor> processor = Memoize.memoize(this::createProcessor);
    private final Supplier<GlobalMemory> memory = Memoize.memoize(this::createMemory);
    private final Supplier<Sensors> sensors = Memoize.memoize(this::createSensors);

    @Override
    public ComputerSystem getComputerSystem() {
        return this.computerSystem.get();
    }

    protected abstract ComputerSystem createComputerSystem();

    @Override
    public CentralProcessor getProcessor() {
        return this.processor.get();
    }

    protected abstract CentralProcessor createProcessor();

    @Override
    public GlobalMemory getMemory() {
        return this.memory.get();
    }

    protected abstract GlobalMemory createMemory();

    @Override
    public Sensors getSensors() {
        return this.sensors.get();
    }

    protected abstract Sensors createSensors();

    @Override
    public List<NetworkIF> getNetworkIFs() {
        return this.getNetworkIFs(false);
    }
}

