/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractHardwareAbstractionLayer;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.builtin.hardware.ComputerSystem;
import org.aoju.bus.health.builtin.hardware.Display;
import org.aoju.bus.health.builtin.hardware.GlobalMemory;
import org.aoju.bus.health.builtin.hardware.GraphicsCard;
import org.aoju.bus.health.builtin.hardware.HWDiskStore;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.health.builtin.hardware.PowerSource;
import org.aoju.bus.health.builtin.hardware.Sensors;
import org.aoju.bus.health.builtin.hardware.SoundCard;
import org.aoju.bus.health.builtin.hardware.UsbDevice;
import org.aoju.bus.health.unix.BsdNetworkIF;
import org.aoju.bus.health.unix.UnixDisplay;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdCentralProcessor;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdComputerSystem;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdGlobalMemory;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdGraphicsCard;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdHWDiskStore;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdPowerSource;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdSensors;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdSoundCard;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdUsbDevice;

@ThreadSafe
public final class OpenBsdHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public ComputerSystem createComputerSystem() {
        return new OpenBsdComputerSystem();
    }

    @Override
    public GlobalMemory createMemory() {
        return new OpenBsdGlobalMemory();
    }

    @Override
    public CentralProcessor createProcessor() {
        return new OpenBsdCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new OpenBsdSensors();
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return OpenBsdPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return OpenBsdHWDiskStore.getDisks();
    }

    @Override
    public List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return BsdNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return OpenBsdUsbDevice.getUsbDevices(tree);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return OpenBsdSoundCard.getSoundCards();
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return OpenBsdGraphicsCard.getGraphicsCards();
    }
}

