/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.accord.platform;

import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.accord.platform.AndroidPlatform;
import org.aoju.bus.http.accord.platform.Platform;

class Android10Platform
extends AndroidPlatform {
    Android10Platform(Class<?> sslParametersClass) {
        super(sslParametersClass, null, null, null, null, null);
    }

    public static Platform buildIfSupported() {
        if (!Android10Platform.isAndroid()) {
            return null;
        }
        try {
            Class<?> sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            return new Android10Platform(sslParametersClass);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        try {
            this.enableSessionTickets(sslSocket);
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            String[] protocolsArray = Android10Platform.alpnProtocolNames(protocols).toArray(new String[0]);
            sslParameters.setApplicationProtocols(protocolsArray);
            sslSocket.setSSLParameters(sslParameters);
        }
        catch (IllegalArgumentException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void enableSessionTickets(SSLSocket sslSocket) {
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        String alpnResult = socket.getApplicationProtocol();
        if (alpnResult == null || alpnResult.isEmpty()) {
            return null;
        }
        return alpnResult;
    }
}

