/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.buffer.Buffer;
import org.aoju.bus.core.io.sink.BufferSink;
import org.aoju.bus.core.io.sink.Sink;
import org.aoju.bus.core.io.source.BufferSource;
import org.aoju.bus.core.io.source.Source;
import org.aoju.bus.core.io.timout.Timeout;
import org.aoju.bus.core.lang.Http;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.bodys.RealResponseBody;
import org.aoju.bus.http.cache.CacheRequest;
import org.aoju.bus.http.cache.CacheStrategy;
import org.aoju.bus.http.cache.InternalCache;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.metric.Internal;

public class CacheInterceptor
implements Interceptor {
    final InternalCache cache;

    public CacheInterceptor(InternalCache cache) {
        this.cache = cache;
    }

    private static Response stripBody(Response response) {
        return null != response && null != response.body() ? response.newBuilder().body(null).build() : response;
    }

    private static Headers combine(Headers cachedHeaders, Headers networkHeaders) {
        String fieldName;
        int i;
        Headers.Builder result = new Headers.Builder();
        int size = cachedHeaders.size();
        for (i = 0; i < size; ++i) {
            fieldName = cachedHeaders.name(i);
            String value = cachedHeaders.value(i);
            if ("Warning".equalsIgnoreCase(fieldName) && value.startsWith("1") || !CacheInterceptor.isContentSpecificHeader(fieldName) && CacheInterceptor.isEndToEnd(fieldName) && null != networkHeaders.get(fieldName)) continue;
            Internal.instance.addLenient(result, fieldName, value);
        }
        size = networkHeaders.size();
        for (i = 0; i < size; ++i) {
            fieldName = networkHeaders.name(i);
            if (CacheInterceptor.isContentSpecificHeader(fieldName) || !CacheInterceptor.isEndToEnd(fieldName)) continue;
            Internal.instance.addLenient(result, fieldName, networkHeaders.value(i));
        }
        return result.build();
    }

    static boolean isEndToEnd(String fieldName) {
        return !"Connection".equalsIgnoreCase(fieldName) && !"Keep-Alive".equalsIgnoreCase(fieldName) && !"Proxy-Authenticate".equalsIgnoreCase(fieldName) && !"Proxy-Authorization".equalsIgnoreCase(fieldName) && !"te".equalsIgnoreCase(fieldName) && !"Trailers".equalsIgnoreCase(fieldName) && !"Transfer-Encoding".equalsIgnoreCase(fieldName) && !"Upgrade".equalsIgnoreCase(fieldName);
    }

    static boolean isContentSpecificHeader(String fieldName) {
        return "Content-Length".equalsIgnoreCase(fieldName) || "Content-Encoding".equalsIgnoreCase(fieldName) || "Content-Type".equalsIgnoreCase(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response cacheCandidate = null != this.cache ? this.cache.get(chain.request()) : null;
        long now = System.currentTimeMillis();
        CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).get();
        Request networkRequest = strategy.networkRequest;
        Response cacheResponse = strategy.cacheResponse;
        if (null != this.cache) {
            this.cache.trackResponse(strategy);
        }
        if (null != cacheCandidate && null == cacheResponse) {
            IoKit.close(cacheCandidate.body());
        }
        if (null == networkRequest && null == cacheResponse) {
            return new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Builder.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
        }
        if (null == networkRequest) {
            return cacheResponse.newBuilder().cacheResponse(CacheInterceptor.stripBody(cacheResponse)).build();
        }
        Response networkResponse = null;
        try {
            networkResponse = chain.proceed(networkRequest);
        }
        finally {
            if (null == networkResponse && null != cacheCandidate) {
                IoKit.close(cacheCandidate.body());
            }
        }
        if (null != cacheResponse) {
            if (networkResponse.code() == 304) {
                Response response = cacheResponse.newBuilder().headers(CacheInterceptor.combine(cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(CacheInterceptor.stripBody(cacheResponse)).networkResponse(CacheInterceptor.stripBody(networkResponse)).build();
                networkResponse.body().close();
                this.cache.trackConditionalCacheHit();
                this.cache.update(cacheResponse, response);
                return response;
            }
            IoKit.close(cacheResponse.body());
        }
        Response response = networkResponse.newBuilder().cacheResponse(CacheInterceptor.stripBody(cacheResponse)).networkResponse(CacheInterceptor.stripBody(networkResponse)).build();
        if (null != this.cache) {
            if (Headers.hasBody(response) && CacheStrategy.isCacheable(response, networkRequest)) {
                CacheRequest cacheRequest = this.cache.put(response);
                return this.cacheWritingResponse(cacheRequest, response);
            }
            if (Http.invalidatesCache(networkRequest.method())) {
                try {
                    this.cache.remove(networkRequest);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return response;
    }

    private Response cacheWritingResponse(final CacheRequest cacheRequest, Response response) throws IOException {
        if (null == cacheRequest) {
            return response;
        }
        Sink cacheBodyUnbuffered = cacheRequest.body();
        if (null == cacheBodyUnbuffered) {
            return response;
        }
        final BufferSource source = response.body().source();
        final BufferSink cacheBody = IoKit.buffer(cacheBodyUnbuffered);
        Source cacheWritingSource = new Source(){
            boolean cacheRequestClosed;

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead;
                try {
                    bytesRead = source.read(sink, byteCount);
                }
                catch (IOException e) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        cacheRequest.abort();
                    }
                    throw e;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        cacheBody.close();
                    }
                    return -1L;
                }
                sink.copyTo(cacheBody.buffer(), sink.size() - bytesRead, bytesRead);
                cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            @Override
            public Timeout timeout() {
                return source.timeout();
            }

            @Override
            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Builder.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    cacheRequest.abort();
                }
                source.close();
            }
        };
        String mediaType = response.header("Content-Type");
        long contentLength = response.body().length();
        return response.newBuilder().body(new RealResponseBody(mediaType, contentLength, IoKit.buffer(cacheWritingSource))).build();
    }
}

