/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpx;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.aoju.bus.http.secure.Authenticator;
import org.aoju.bus.http.secure.Credentials;

public class HttpProxy {
    public final String hostAddress;
    public final int port;
    public final String user;
    public final String password;
    public final Proxy.Type type;

    public HttpProxy(String hostAddress, int port, String user, String password, Proxy.Type type) {
        this.hostAddress = hostAddress;
        this.port = port;
        this.user = user;
        this.password = password;
        this.type = type;
    }

    public HttpProxy(String hostAddress, int port) {
        this(hostAddress, port, null, null, Proxy.Type.HTTP);
    }

    public Proxy proxy() {
        return new Proxy(this.type, new InetSocketAddress(this.hostAddress, this.port));
    }

    public Authenticator authenticator() {
        return (route, response) -> {
            String credential = Credentials.basic(this.user, this.password);
            return response.request().newBuilder().header("Proxy-Authorization", credential).header("Proxy-Connection", "Keep-Alive").build();
        };
    }
}

