/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.image.galaxy.media.MultipartParser;
import org.aoju.bus.logger.Logger;

public class MultipartReader {
    public static final int HEADER_PART_MAX_SIZE = 16384;
    private final InputStream inputStream;
    private final byte[] boundary;
    private final byte[] buffer;
    private final int bufferSize;
    private String headerEncoding;
    private int currentBoundaryLength;
    private int headBuffer = 0;
    private int tailBuffer = 0;

    public MultipartReader(InputStream input, byte[] boundary) {
        this(input, boundary, 4096);
    }

    public MultipartReader(InputStream input, byte[] boundary, int bufSize) {
        this.inputStream = input;
        this.bufferSize = bufSize;
        this.buffer = new byte[bufSize];
        int blength = MultipartParser.Separator.BOUNDARY.getType().length;
        this.boundary = new byte[boundary.length + blength];
        this.currentBoundaryLength = boundary.length + blength;
        System.arraycopy(MultipartParser.Separator.BOUNDARY.getType(), 0, this.boundary, 0, blength);
        System.arraycopy(boundary, 0, this.boundary, blength, boundary.length);
    }

    protected static boolean compareArrays(byte[] a, byte[] b, int count) {
        for (int i = 0; i < count; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public byte readByte() throws IOException {
        if (this.headBuffer == this.tailBuffer) {
            this.headBuffer = 0;
            this.tailBuffer = this.inputStream.read(this.buffer, this.headBuffer, this.bufferSize);
            if (this.tailBuffer == -1) {
                throw new InternalException("No more data is available");
            }
        }
        return this.buffer[this.headBuffer++];
    }

    public boolean readBoundary() throws IOException {
        this.headBuffer += this.currentBoundaryLength;
        byte[] marker = new byte[]{this.readByte(), this.readByte()};
        boolean nextPart = false;
        if (MultipartReader.compareArrays(marker, MultipartParser.Separator.STREAM.getType(), 2)) {
            nextPart = false;
        } else if (MultipartReader.compareArrays(marker, MultipartParser.Separator.FIELD.getType(), 2)) {
            nextPart = true;
        } else {
            throw new InternalException("Unexpected bytes after the boundary separator");
        }
        return nextPart;
    }

    public String readHeaders() throws IOException {
        int k = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int headerSize = 0;
        byte[] hsep = MultipartParser.Separator.HEADER.getType();
        while (k < hsep.length) {
            byte b = this.readByte();
            if (++headerSize > 16384) {
                throw new InternalException("Header content is larger than 16384 bytes (max size defined in reader)");
            }
            k = b == hsep[k] ? ++k : 0;
            baos.write(b);
        }
        String headers = null;
        if (null != this.headerEncoding) {
            try {
                headers = baos.toString(this.headerEncoding);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("Decoding header", e);
            }
        }
        if (null == headers) {
            headers = baos.toString();
        }
        return headers;
    }

    public boolean skipFirstBoundary() throws IOException {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.currentBoundaryLength = this.boundary.length - 2;
        try {
            this.discardDataBeforeDelimiter();
            boolean bl = this.readBoundary();
            return bl;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.currentBoundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
        }
    }

    public PartInputStream newPartInputStream() {
        return new PartInputStream();
    }

    protected void discardDataBeforeDelimiter() throws IOException {
        try (PartInputStream in = this.newPartInputStream();){
            byte[] pBuffer = new byte[1024];
            while (in.read(pBuffer) != -1) {
            }
        }
    }

    protected int findFirstBoundaryCharacter(int start) {
        for (int i = start; i < this.tailBuffer; ++i) {
            if (this.buffer[i] != this.boundary[0]) continue;
            return i;
        }
        return -1;
    }

    protected int findStartingBoundaryPosition() {
        int start;
        int b = 0;
        int end = this.tailBuffer - this.currentBoundaryLength;
        for (start = this.headBuffer; start <= end && b != this.currentBoundaryLength; ++start) {
            if ((start = this.findFirstBoundaryCharacter(start)) == -1 || start > end) {
                return -1;
            }
            for (b = 1; b < this.currentBoundaryLength && this.buffer[start + b] == this.boundary[b]; ++b) {
            }
        }
        if (b == this.currentBoundaryLength) {
            return start - 1;
        }
        return -1;
    }

    public class PartInputStream
    extends InputStream
    implements AutoCloseable {
        private static final String STREAM_CLOSED_EX = "PartInputStream has been closed";
        private int position;
        private long total;
        private int offset;
        private boolean closed;

        PartInputStream() {
            this.moveToBoundary();
        }

        private void moveToBoundary() {
            this.position = MultipartReader.this.findStartingBoundaryPosition();
            if (this.position == -1) {
                this.offset = MultipartReader.this.tailBuffer - MultipartReader.this.headBuffer > MultipartReader.this.boundary.length ? MultipartReader.this.boundary.length : MultipartReader.this.tailBuffer - MultipartReader.this.headBuffer;
            }
        }

        private int readInputStream() throws IOException {
            int k;
            if (this.position != -1) {
                return 0;
            }
            this.total += (long)(MultipartReader.this.tailBuffer - MultipartReader.this.headBuffer - this.offset);
            System.arraycopy(MultipartReader.this.buffer, MultipartReader.this.tailBuffer - this.offset, MultipartReader.this.buffer, 0, this.offset);
            MultipartReader.this.headBuffer = 0;
            MultipartReader.this.tailBuffer = this.offset;
            do {
                int readBytes;
                if ((readBytes = MultipartReader.this.inputStream.read(MultipartReader.this.buffer, MultipartReader.this.tailBuffer, MultipartReader.this.bufferSize - MultipartReader.this.tailBuffer)) == -1) {
                    throw new InternalException("Unexpect end of stream");
                }
                MultipartReader.this.tailBuffer += readBytes;
                this.moveToBoundary();
            } while ((k = this.available()) <= 0 && this.position == -1);
            return k;
        }

        public long getTotal() {
            return this.total;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new InternalException(STREAM_CLOSED_EX);
            }
            if (len == 0) {
                return 0;
            }
            int k = this.available();
            if (k == 0 && (k = this.readInputStream()) == 0) {
                return -1;
            }
            k = Math.min(k, len);
            System.arraycopy(MultipartReader.this.buffer, MultipartReader.this.headBuffer, b, off, k);
            MultipartReader.this.headBuffer += k;
            this.total += (long)k;
            return k;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new InternalException(STREAM_CLOSED_EX);
            }
            if (this.available() == 0 && this.readInputStream() == 0) {
                return -1;
            }
            ++this.total;
            return MultipartReader.this.buffer[MultipartReader.this.headBuffer++] & 0xFF;
        }

        @Override
        public int available() {
            if (this.position == -1) {
                return MultipartReader.this.tailBuffer - MultipartReader.this.headBuffer - this.offset;
            }
            return this.position - MultipartReader.this.headBuffer;
        }

        @Override
        public long skip(long bytes) throws IOException {
            if (this.closed) {
                throw new InternalException(STREAM_CLOSED_EX);
            }
            int k = this.available();
            if (k == 0 && (k = this.readInputStream()) == 0) {
                return 0L;
            }
            long skipBytes = Math.min((long)k, bytes);
            MultipartReader.this.headBuffer = (int)((long)MultipartReader.this.headBuffer + skipBytes);
            return skipBytes;
        }

        @Override
        public void close() throws IOException {
            int k;
            if (this.closed) {
                return;
            }
            while ((k = this.available()) != 0 || (k = this.readInputStream()) != 0) {
                this.skip(k);
            }
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

