/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.console;

import java.util.function.Function;
import org.aoju.bus.core.lang.ansi.AnsiColor;
import org.aoju.bus.core.lang.ansi.AnsiEncoder;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.dialect.console.ConsoleLog;
import org.aoju.bus.logger.level.Level;

public class ConsoleColorLog
extends ConsoleLog {
    private static final AnsiColor COLOR_CLASSNAME = AnsiColor.CYAN;
    private static final AnsiColor COLOR_TIME = AnsiColor.WHITE;
    private static final AnsiColor COLOR_NONE = AnsiColor.DEFAULT;
    private static Function<Level, AnsiColor> colorFactory = level -> {
        switch (level) {
            case DEBUG: 
            case INFO: {
                return AnsiColor.GREEN;
            }
            case WARN: {
                return AnsiColor.YELLOW;
            }
            case ERROR: {
                return AnsiColor.RED;
            }
            case TRACE: {
                return AnsiColor.MAGENTA;
            }
        }
        return COLOR_NONE;
    };

    public ConsoleColorLog(String name) {
        super(name);
    }

    public ConsoleColorLog(Class<?> clazz) {
        super(clazz);
    }

    public static void setColorFactory(Function<Level, AnsiColor> colorFactory) {
        ConsoleColorLog.colorFactory = colorFactory;
    }

    @Override
    public synchronized void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        String template = AnsiEncoder.encode(COLOR_TIME, "[%s]", colorFactory.apply(level), "[%-5s]%s", COLOR_CLASSNAME, "%-30s: ", COLOR_NONE, "%s%n");
        System.out.format(template, DateKit.now(), level.name(), " - ", ClassKit.getShortClassName(this.getName()), StringKit.format((CharSequence)format, arguments));
    }
}

