/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.reflect;

import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.function.Fn;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.SoftCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.mapping.MappedStatement;

public class Reflector {
    public static final Cache CLASS_CACHE = new SoftCache((Cache)new PerpetualCache("MAPPER_CLASS_CACHE"));
    private static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    private static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");

    private Reflector() {
    }

    public static String fnToFieldName(Fn fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke((Object)fn, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            if (GET_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(3);
            } else if (IS_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(2);
            }
            return Introspector.decapitalize(getter);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalException(e);
        }
    }

    public static Class<?> getMapperClass(String msId) {
        ClassLoader[] classLoader;
        if (msId.indexOf(".") == -1) {
            throw new InternalException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        String mapperClassStr = msId.substring(0, msId.lastIndexOf("."));
        Class<?> mapperClass = (Class<?>)CLASS_CACHE.getObject((Object)mapperClassStr);
        if (mapperClass != null) {
            return mapperClass;
        }
        for (ClassLoader cl : classLoader = Reflector.getClassLoaders()) {
            if (null == cl) continue;
            try {
                mapperClass = Class.forName(mapperClassStr, true, cl);
                if (mapperClass == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (mapperClass == null) {
            throw new InternalException("class loaders failed to locate the class " + mapperClassStr);
        }
        CLASS_CACHE.putObject((Object)mapperClassStr, (Object)mapperClass);
        return mapperClass;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), Reflector.class.getClassLoader()};
    }

    public static String getMethodName(MappedStatement ms) {
        return Reflector.getMethodName(ms.getId());
    }

    public static String getMethodName(String msId) {
        return msId.substring(msId.lastIndexOf(".") + 1);
    }
}

