/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.aoju.bus.core.lang.ZoneId;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.aliyun.AliyunProperty;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;

public class AliyunVmsProvider
extends AliyunProvider<AliyunProperty, Context> {
    public AliyunVmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(AliyunProperty entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("SignatureMethod", "HMAC-SHA1");
        bodys.put("SignatureNonce", UUID.randomUUID().toString());
        bodys.put("AccessKeyId", this.context.getAppKey());
        bodys.put("SignatureVersion", "1.0");
        bodys.put("Timestamp", DateKit.format(new Date(), "yyyy-MM-dd'T'HH:mm:ss'Z'", ZoneId.UTC.name()));
        bodys.put("Format", "JSON");
        bodys.put("Action", "SingleCallByTts");
        bodys.put("Version", "2017-05-25");
        bodys.put("RegionId", "cn-hangzhou");
        bodys.put("CalledNumber", entity.getReceive());
        bodys.put("CalledShowNumber", entity.getSender());
        bodys.put("PlayTimes", entity.getPlayTimes());
        bodys.put("TtsParam", entity.getParams());
        bodys.put("TtsCode", entity.getTemplate());
        bodys.put("Signature", this.getSign(bodys));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String text : bodys.keySet()) {
            map.put(this.specialUrlEncode(text), this.specialUrlEncode((String)bodys.get(text)));
        }
        return this.checkResponse(Httpx.get(entity.getUrl(), map));
    }
}

