/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.upyun;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.upyun.UpyunProperty;

public class UpyunSmsProvider
extends AbstractProvider<UpyunProperty, Context> {
    public UpyunSmsProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(UpyunProperty entity) {
        HashMap<String, Object> bodys = new HashMap<String, Object>();
        bodys.put("template_id", entity.getTemplate());
        bodys.put("mobile", entity.getReceive());
        bodys.put("vars", StringKit.split((CharSequence)entity.getParams(), "|").toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", entity.getToken());
        String response = Httpx.post(entity.getUrl(), bodys, headers);
        List<UpyunProperty.MessageId> list = JsonKit.toList(response, UpyunProperty.MessageId.class);
        if (CollKit.isEmpty(list)) {
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
        boolean succeed = list.stream().filter(Objects::nonNull).anyMatch(UpyunProperty.MessageId::succeed);
        String errcode = succeed ? Builder.ErrorCode.SUCCESS.getCode() : Builder.ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? Builder.ErrorCode.SUCCESS.getMsg() : Builder.ErrorCode.FAILURE.getMsg();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }

    public boolean succeed(String errorCode, String msgId) {
        return StringKit.isBlank(errorCode) && StringKit.isNotBlank(msgId);
    }
}

