/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.builtin;

import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.bridge.LocalOfficeContextAware;
import org.aoju.bus.office.builtin.AbstractOffice;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.provider.LocalOfficeProvider;
import org.aoju.bus.office.provider.SourceDocumentProvider;

public abstract class AbstractLocalOffice
extends AbstractOffice {
    private static final String ERROR_MESSAGE_LOAD = "Could not open document: ";
    protected final Map<String, Object> loadProperties;

    public AbstractLocalOffice(SourceDocumentProvider source) {
        this(source, null);
    }

    public AbstractLocalOffice(SourceDocumentProvider source, Map<String, Object> loadProperties) {
        super(source);
        this.loadProperties = loadProperties;
    }

    protected static void appendProperties(Map<String, Object> properties, Map<String, Object> toAddProperties) {
        Optional.ofNullable(toAddProperties).ifPresent(properties::putAll);
    }

    protected Map<String, Object> getLoadProperties() {
        HashMap<String, Object> loadProps = new HashMap<String, Object>(Optional.ofNullable(this.loadProperties).orElse(LocalOfficeProvider.DEFAULT_LOAD_PROPERTIES));
        Optional.ofNullable(this.source.getFormat()).ifPresent(fmt -> AbstractLocalOffice.appendProperties(loadProps, fmt.getLoadProperties()));
        return loadProps;
    }

    protected XComponent loadDocument(LocalOfficeContextAware context, File sourceFile) throws InternalException {
        try {
            XComponent document = context.getComponentLoader().loadComponentFromURL(Builder.toUrl(sourceFile), "_blank", 0, Builder.toUnoProperties(this.getLoadProperties()));
            return document;
        }
        catch (ErrorCodeIOException exception) {
            throw new InternalException(ERROR_MESSAGE_LOAD + sourceFile.getName() + "; errorCode: " + exception.ErrCode, exception);
        }
        catch (IOException | IllegalArgumentException exception) {
            throw new InternalException(ERROR_MESSAGE_LOAD + sourceFile.getName(), exception);
        }
    }

    protected void closeDocument(XComponent document) {
        if (null != document) {
            XCloseable closeable = Lo.qi(XCloseable.class, document);
            if (ObjectKit.isEmpty(closeable)) {
                Lo.qi(XComponent.class, document).dispose();
            } else {
                try {
                    closeable.close(true);
                }
                catch (CloseVetoException closeVetoEx) {
                    throw new InternalException(closeVetoEx);
                }
            }
        }
    }
}

