/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.thread.NamedThreadFactory;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.builtin.MadeInOffice;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.metric.OfficeManagerEntryBuilder;
import org.aoju.bus.office.metric.SuspendableThread;

public abstract class AbstractOfficeEntryManager
implements OfficeManager {
    protected final OfficeManagerEntryBuilder config;
    protected final SuspendableThread taskExecutor;
    protected Future<?> currentFuture;

    public AbstractOfficeEntryManager(OfficeManagerEntryBuilder config) {
        this.config = config;
        this.taskExecutor = new SuspendableThread(new NamedThreadFactory("OfficeManagerPoolEntry"));
    }

    @Override
    public final void execute(MadeInOffice task) throws InternalException {
        this.currentFuture = this.taskExecutor.submit(() -> {
            this.doExecute(task);
            return null;
        });
        try {
            Logger.debug("Waiting for task to complete...", new Object[0]);
            this.currentFuture.get(this.config.getTaskExecutionTimeout(), TimeUnit.MILLISECONDS);
            Logger.debug("Task executed successfully", new Object[0]);
        }
        catch (TimeoutException timeoutEx) {
            this.handleExecuteTimeoutException(timeoutEx);
            throw new InternalException("Task did not complete within timeout", timeoutEx);
        }
        catch (ExecutionException executionEx) {
            if (executionEx.getCause() instanceof InternalException) {
                throw (InternalException)executionEx.getCause();
            }
            throw new InternalException("Task failed", executionEx.getCause());
        }
        catch (Exception ex) {
            throw new InternalException("Task failed", ex);
        }
        finally {
            this.currentFuture = null;
        }
    }

    protected abstract void doExecute(MadeInOffice var1) throws Exception;

    protected void handleExecuteTimeoutException(TimeoutException timeoutEx) {
        Logger.debug("Handleling task execution timeout...", new Object[0]);
    }

    @Override
    public boolean isRunning() {
        return !this.taskExecutor.isShutdown();
    }

    @Override
    public final void start() throws InternalException {
        if (this.taskExecutor.isShutdown()) {
            throw new IllegalStateException("This office manager (pool entry) has been shutdown.");
        }
        this.doStart();
    }

    protected abstract void doStart() throws InternalException;

    @Override
    public final void stop() throws InternalException {
        this.taskExecutor.setAvailable(false);
        this.taskExecutor.shutdownNow();
        this.doStop();
    }

    protected abstract void doStop() throws InternalException;
}

