/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.bridge.LocalOfficeBridgeFactory;
import org.aoju.bus.office.metric.AbstractRetryable;
import org.aoju.bus.office.metric.OfficeProcess;

public class ConnectRetryable
extends AbstractRetryable {
    private final OfficeProcess process;
    private final LocalOfficeBridgeFactory localOffice;

    public ConnectRetryable(LocalOfficeBridgeFactory localOffice) {
        this(null, localOffice);
    }

    public ConnectRetryable(OfficeProcess process, LocalOfficeBridgeFactory localOffice) {
        this.process = process;
        this.localOffice = localOffice;
    }

    @Override
    protected void attempt() throws InternalException {
        try {
            this.localOffice.connect();
        }
        catch (InternalException connectionEx) {
            if (ObjectKit.isEmpty(this.process)) {
                throw new InternalException(connectionEx);
            }
            Integer exitCode = this.process.getExitCode();
            if (ObjectKit.isEmpty(exitCode)) {
                throw new InternalException(connectionEx);
            }
            if (exitCode.equals(81)) {
                Logger.warn("Office process died with exit code 81; restarting it", new Object[0]);
                this.process.start(true);
                throw new InternalException(connectionEx);
            }
            throw new InternalException("Office process died with exit code " + exitCode, connectionEx);
        }
    }
}

