/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetRidReader
extends DefaultHandler {
    private static final String TAG_NAME = "sheet";
    private static final String RID_ATTR = "r:id";
    private static final String SHEET_ID_ATTR = "sheetId";
    private static final String NAME_ATTR = "name";
    private final Map<Integer, Integer> ID_RID_MAP = new LinkedHashMap<Integer, Integer>();
    private final Map<String, Integer> NAME_RID_MAP = new LinkedHashMap<String, Integer>();

    public static SheetRidReader parse(XSSFReader reader) {
        return new SheetRidReader().read(reader);
    }

    public SheetRidReader read(XSSFReader xssfReader) {
        InputStream workbookData = null;
        try {
            workbookData = xssfReader.getWorkbookData();
            ExcelSaxKit.readFrom(workbookData, this);
        }
        catch (InvalidFormatException e) {
            throw new InternalException(e);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            IoKit.close(workbookData);
        }
        return this;
    }

    public Integer getRidBySheetId(int sheetId) {
        return this.ID_RID_MAP.get(sheetId);
    }

    public Integer getRidBySheetIdBase0(int sheetId) {
        Integer rid = this.getRidBySheetId(sheetId + 1);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public Integer getRidByName(String sheetName) {
        return this.NAME_RID_MAP.get(sheetName);
    }

    public Integer getRidByNameBase0(String sheetName) {
        Integer rid = this.getRidByName(sheetName);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public Integer getRidByIndex(int index) {
        return CollKit.get(this.NAME_RID_MAP.values(), index);
    }

    public Integer getRidByIndexBase0(int index) {
        Integer rid = CollKit.get(this.NAME_RID_MAP.values(), index);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public List<String> getSheetNames() {
        return CollKit.toList(this.NAME_RID_MAP.keySet());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_NAME.equalsIgnoreCase(localName)) {
            String sheetIdStr;
            String ridStr = attributes.getValue(RID_ATTR);
            if (StringKit.isEmpty(ridStr)) {
                return;
            }
            int rid = Integer.parseInt(StringKit.removePrefixIgnoreCase(ridStr, "rId"));
            String name = attributes.getValue(NAME_ATTR);
            if (StringKit.isNotEmpty(name)) {
                this.NAME_RID_MAP.put(name, rid);
            }
            if (StringKit.isNotEmpty(sheetIdStr = attributes.getValue(SHEET_ID_ATTR))) {
                this.ID_RID_MAP.put(Integer.parseInt(sheetIdStr), rid);
            }
        }
    }
}

