/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.aoju.bus.core.exception.PageException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.AutoDialect;
import org.aoju.bus.pager.Dialect;
import org.aoju.bus.pager.dialect.AbstractPaging;
import org.aoju.bus.pager.dialect.auto.Defalut;
import org.aoju.bus.pager.dialect.auto.Druid;
import org.aoju.bus.pager.dialect.auto.Early;
import org.aoju.bus.pager.dialect.auto.Hikari;
import org.aoju.bus.pager.dialect.base.Db2;
import org.aoju.bus.pager.dialect.base.Firebird;
import org.aoju.bus.pager.dialect.base.HerdDB;
import org.aoju.bus.pager.dialect.base.Hsqldb;
import org.aoju.bus.pager.dialect.base.Informix;
import org.aoju.bus.pager.dialect.base.MySql;
import org.aoju.bus.pager.dialect.base.Oracle;
import org.aoju.bus.pager.dialect.base.Oracle9i;
import org.aoju.bus.pager.dialect.base.Oscar;
import org.aoju.bus.pager.dialect.base.PostgreSql;
import org.aoju.bus.pager.dialect.base.SqlServer;
import org.aoju.bus.pager.dialect.base.SqlServer2012;
import org.apache.ibatis.mapping.MappedStatement;

public class PageAutoDialect {
    private static final Map<String, Class<? extends Dialect>> dialectAliasMap = new HashMap<String, Class<? extends Dialect>>();
    private static final Map<String, Class<? extends AutoDialect>> autoDialectMap = new HashMap<String, Class<? extends AutoDialect>>();
    private final Map<Object, AbstractPaging> urlDialectMap = new ConcurrentHashMap<Object, AbstractPaging>();
    private boolean autoDialect = true;
    private AutoDialect autoDialectDelegate;
    private Properties properties;
    private ReentrantLock lock = new ReentrantLock();
    private AbstractPaging delegate;
    private ThreadLocal<AbstractPaging> dialectThreadLocal = new ThreadLocal();

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public static void registerAutoDialectAlias(String alias, Class<? extends AutoDialect> autoDialectClass) {
        autoDialectMap.put(alias, autoDialectClass);
    }

    public static String fromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        for (String dialect : dialectAliasMap.keySet()) {
            if (!url.contains(":" + dialect.toLowerCase() + ":")) continue;
            return dialect;
        }
        return null;
    }

    public static Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    public static AbstractPaging instanceDialect(String dialectClass, Properties properties) {
        AbstractPaging dialect;
        if (StringKit.isEmpty(dialectClass)) {
            throw new PageException("\u4f7f\u7528 PageHelper \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e helper \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = PageAutoDialect.resloveDialectClass(dialectClass);
            if (!AbstractPaging.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u4f7f\u7528 PageContext \u65f6\uff0c\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractPaging.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractPaging)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    public AbstractPaging getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPaging autoGetDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        Object dialectKey = this.autoDialectDelegate.extractDialectKey(ms, dataSource, this.properties);
        if (dialectKey == null) {
            return this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties);
        }
        if (!this.urlDialectMap.containsKey(dialectKey)) {
            this.lock.lock();
            try {
                if (!this.urlDialectMap.containsKey(dialectKey)) {
                    this.urlDialectMap.put(dialectKey, this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.urlDialectMap.get(dialectKey);
    }

    private void initDialectAlias(Properties properties) {
        String dialectAlias = properties.getProperty("dialectAlias");
        if (StringKit.isNotEmpty(dialectAlias)) {
            String[] alias = dialectAlias.split(";");
            for (int i = 0; i < alias.length; ++i) {
                String[] kv = alias[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("dialectAlias \u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u6309\u7167 alias1=xx.dialectClass;alias2=dialectClass2 \u7684\u5f62\u5f0f\u8fdb\u884c\u914d\u7f6e!");
                }
                for (int j = 0; j < kv.length; ++j) {
                    try {
                        Class<?> diallectClass = Class.forName(kv[1]);
                        PageAutoDialect.registerDialectAlias(kv[0], diallectClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("\u8bf7\u786e\u4fdd dialectAlias \u914d\u7f6e\u7684 Dialect \u5b9e\u73b0\u7c7b\u5b58\u5728!", e);
                    }
                }
            }
        }
    }

    private void initAutoDialectClass(Properties properties) {
        String autoDialectClassStr = properties.getProperty("autoDialectClass");
        if (StringKit.isNotEmpty(autoDialectClassStr)) {
            try {
                Class<Object> autoDialectClass = autoDialectMap.containsKey(autoDialectClassStr) ? autoDialectMap.get(autoDialectClassStr) : Class.forName(autoDialectClassStr);
                this.autoDialectDelegate = (AutoDialect)autoDialectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u8bf7\u786e\u4fdd autoDialectClass \u914d\u7f6e\u7684 AutoDialect \u5b9e\u73b0\u7c7b(" + autoDialectClassStr + ")\u5b58\u5728!", e);
            }
            catch (Exception e) {
                throw new RuntimeException(autoDialectClassStr + " \u7c7b\u5fc5\u987b\u63d0\u4f9b\u65e0\u53c2\u7684\u6784\u9020\u65b9\u6cd5", e);
            }
        } else {
            this.autoDialectDelegate = new Defalut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDelegateDialect(MappedStatement ms, String dialectClass) {
        if (StringKit.isNotEmpty(dialectClass)) {
            AbstractPaging dialect = this.urlDialectMap.get(dialectClass);
            if (dialect == null) {
                this.lock.lock();
                try {
                    dialect = this.urlDialectMap.get(dialectClass);
                    if (dialect == null) {
                        dialect = PageAutoDialect.instanceDialect(dialectClass, this.properties);
                        this.urlDialectMap.put(dialectClass, dialect);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.dialectThreadLocal.set(dialect);
        } else if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.autoGetDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.autoGetDialect(ms));
            }
        }
    }

    public void setProperties(Properties properties) {
        this.initAutoDialectClass(properties);
        String useSqlserver2012 = properties.getProperty("useSqlserver2012");
        if (StringKit.isNotEmpty(useSqlserver2012) && Boolean.parseBoolean(useSqlserver2012)) {
            PageAutoDialect.registerDialectAlias("sqlserver", SqlServer2012.class);
            PageAutoDialect.registerDialectAlias("sqlserver2008", SqlServer.class);
        }
        this.initDialectAlias(properties);
        String dialect = properties.getProperty("dialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringKit.isNotEmpty(runtimeDialect) && "TRUE".equalsIgnoreCase(runtimeDialect)) {
            this.autoDialect = false;
            this.properties = properties;
        } else if (StringKit.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.delegate = PageAutoDialect.instanceDialect(dialect, properties);
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("hsqldb", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("h2", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("phoenix", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("postgresql", PostgreSql.class);
        PageAutoDialect.registerDialectAlias("mysql", MySql.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySql.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySql.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDB.class);
        PageAutoDialect.registerDialectAlias("oracle", Oracle.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9i.class);
        PageAutoDialect.registerDialectAlias("db2", Db2.class);
        PageAutoDialect.registerDialectAlias("informix", Informix.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", Informix.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServer.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012.class);
        PageAutoDialect.registerDialectAlias("dm", Oracle.class);
        PageAutoDialect.registerDialectAlias("edb", Oracle.class);
        PageAutoDialect.registerDialectAlias("oscar", Oscar.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySql.class);
        PageAutoDialect.registerDialectAlias("highgo", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("xugu", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("impala", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("firebirdsql", Firebird.class);
        PageAutoDialect.registerAutoDialectAlias("early", Early.class);
        PageAutoDialect.registerAutoDialectAlias("hikari", Hikari.class);
        PageAutoDialect.registerAutoDialectAlias("druid", Druid.class);
        PageAutoDialect.registerAutoDialectAlias("default", Defalut.class);
    }
}

