/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.intercept;

import org.aoju.bus.logger.Logger;
import org.aoju.bus.proxy.Builder;
import org.aoju.bus.proxy.Interceptor;
import org.aoju.bus.proxy.Invocation;

public class LoggingInterceptor
implements Interceptor {
    private static final int BUFFER_SIZE = 100;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        this.entry(methodName, invocation.getArguments());
        try {
            Object result = invocation.proceed();
            if (Void.TYPE.equals(invocation.getMethod().getReturnType())) {
                this.voidExit(methodName);
            } else {
                this.exit(methodName, result);
            }
            return result;
        }
        catch (Throwable t) {
            this.exception(methodName, t);
            throw t;
        }
    }

    private void entry(String methodName, Object[] args) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("BEGIN ");
        buffer.append(methodName);
        buffer.append("(");
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            Object arg = args[i];
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, arg);
        }
        buffer.append(")");
        Logger.debug(buffer.toString(), new Object[0]);
    }

    private void convert(StringBuffer buffer, Object input) {
        if (null == input) {
            buffer.append("<null>");
            return;
        }
        if (!(input instanceof Object[])) {
            buffer.append(input.toString());
            return;
        }
        buffer.append("(");
        buffer.append(Builder.getJavaClassName(input.getClass()));
        buffer.append("){");
        Object[] array = (Object[])input;
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, array[i]);
        }
        buffer.append("}");
    }

    private void exception(String methodName, Throwable t) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("EXCEPTION ");
        buffer.append(methodName);
        buffer.append("() -- ");
        buffer.append(t.getClass().getName());
        Logger.debug(buffer.toString(), t);
    }

    private void exit(String methodName, Object result) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("END ");
        buffer.append(methodName);
        buffer.append("() [");
        this.convert(buffer, result);
        buffer.append("]");
        Logger.debug(buffer.toString(), new Object[0]);
    }

    private void voidExit(String methodName) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("END ");
        buffer.append(methodName);
        buffer.append("()");
        Logger.debug(buffer.toString(), new Object[0]);
    }
}

