/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.provider;

import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.proxy.Provider;

public class BeanProvider
implements Provider {
    private Class beanClass;

    public BeanProvider() {
    }

    public BeanProvider(Class beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Object getObject() {
        try {
            if (null == this.beanClass) {
                throw new InternalException("No bean class provided.");
            }
            return this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InternalException("Class " + this.beanClass.getName() + " is not concrete.", e);
        }
        catch (IllegalAccessException e) {
            throw new InternalException("Constructor for class " + this.beanClass.getName() + " is not accessible.", e);
        }
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }
}

