/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.sensitive;

import com.alibaba.fastjson.serializer.BeanContext;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.TypeKit;
import org.aoju.bus.sensitive.Context;
import org.aoju.bus.sensitive.Registry;
import org.aoju.bus.sensitive.annotation.Condition;
import org.aoju.bus.sensitive.annotation.Entry;
import org.aoju.bus.sensitive.annotation.Shield;
import org.aoju.bus.sensitive.provider.ConditionProvider;
import org.aoju.bus.sensitive.provider.StrategyProvider;

public class Filter
implements ContextValueFilter {
    private final Context sensitiveContext;

    public Filter(Context context) {
        this.sensitiveContext = context;
    }

    private static ConditionProvider getConditionOpt(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Condition sensitiveCondition = annotation.annotationType().getAnnotation(Condition.class);
            if (!ObjectKit.isNotNull(sensitiveCondition)) continue;
            return ClassKit.newInstance(sensitiveCondition.value());
        }
        return null;
    }

    public Object process(BeanContext context, Object object, String name, Object value) {
        Object firstCollectionEntry;
        Collection entryCollection;
        Object firstArrayEntry;
        Class<?> entryFieldClass;
        Object[] arrays;
        if (ObjectKit.isNull(context)) {
            return value;
        }
        Field field = context.getField();
        Class clazz = context.getBeanClass();
        List<Field> fieldList = ClassKit.getAllFieldList(clazz);
        this.sensitiveContext.setCurrentField(field);
        this.sensitiveContext.setCurrentObject(object);
        this.sensitiveContext.setBeanClass(clazz);
        this.sensitiveContext.setAllFieldList(fieldList);
        Entry sensitiveEntry = field.getAnnotation(Entry.class);
        if (ObjectKit.isNull(sensitiveEntry)) {
            this.sensitiveContext.setEntry(value);
            return this.handleSensitive(this.sensitiveContext, field);
        }
        Class<?> fieldTypeClass = field.getType();
        if (TypeKit.isJavaBean(fieldTypeClass)) {
            return value;
        }
        if (TypeKit.isMap(fieldTypeClass)) {
            return value;
        }
        if (TypeKit.isArray(fieldTypeClass) && ArrayKit.isNotEmpty(arrays = (Object[])value) && this.isBaseType(entryFieldClass = (firstArrayEntry = ArrayKit.firstNotNull(arrays).get()).getClass())) {
            int arrayLength = arrays.length;
            Object newArray = Array.newInstance(entryFieldClass, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object entry = arrays[i];
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                Array.set(newArray, i, result);
            }
            return newArray;
        }
        if (TypeKit.isCollection(fieldTypeClass) && CollKit.isNotEmpty(entryCollection = (Collection)value) && this.isBaseType((firstCollectionEntry = CollKit.firstNotNullElem(entryCollection).get()).getClass())) {
            ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
            for (Object entry : entryCollection) {
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                newResultList.add(result);
            }
            return newResultList;
        }
        return value;
    }

    private Object handleSensitive(Context context, Field field) {
        try {
            StrategyProvider strategyProvider;
            ConditionProvider conditionOptional;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Object originalFieldVal = context.getEntry();
            Shield sensitive = field.getAnnotation(Shield.class);
            if (ObjectKit.isNotNull(sensitive) && (condition = (conditionClass = sensitive.condition()).newInstance()).valid(context)) {
                StrategyProvider strategy = Registry.require(sensitive.type());
                if (ObjectKit.isEmpty(strategy)) {
                    Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                    strategy = strategyClass.newInstance();
                }
                this.sensitiveContext.setEntry(null);
                return strategy.build(originalFieldVal, context);
            }
            Annotation[] annotations = field.getAnnotations();
            if (ArrayKit.isNotEmpty(annotations) && ObjectKit.isNotEmpty(conditionOptional = Filter.getConditionOpt(annotations)) && ObjectKit.isEmpty(strategyProvider = Registry.require(annotations))) {
                this.sensitiveContext.setEntry(null);
                return strategyProvider.build(originalFieldVal, context);
            }
            this.sensitiveContext.setEntry(null);
            return originalFieldVal;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalException(e);
        }
    }

    private boolean isBaseType(Class fieldTypeClass) {
        if (TypeKit.isBase(fieldTypeClass)) {
            return true;
        }
        return !TypeKit.isJavaBean(fieldTypeClass) && !TypeKit.isArray(fieldTypeClass) && !TypeKit.isCollection(fieldTypeClass) && !TypeKit.isMap(fieldTypeClass);
    }
}

