/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.getter.BasicType;
import org.aoju.bus.core.getter.OptBasicType;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.io.watcher.SimpleWatcher;
import org.aoju.bus.core.io.watcher.WatchMonitor;
import org.aoju.bus.core.io.watcher.Watcher;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.WatchKit;
import org.aoju.bus.logger.Logger;

public final class Properties
extends java.util.Properties
implements BasicType<String>,
OptBasicType<String> {
    private static final long serialVersionUID = 1L;
    private Resource resource;
    private WatchMonitor watchMonitor;
    private Charset charset = org.aoju.bus.core.lang.Charset.ISO_8859_1;

    public Properties() {
    }

    public Properties(String path) {
        this(path, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(String path, String charsetName) {
        this(path, org.aoju.bus.core.lang.Charset.charset(charsetName));
    }

    public Properties(String path, Charset charset) {
        Assert.notBlank(path, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(FileKit.getResourceObject(path));
    }

    public Properties(File propertiesFile) {
        this(propertiesFile, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public Properties(File propertiesFile, Charset charset) {
        Assert.notNull(propertiesFile, "Null properties file!", new Object[0]);
        this.charset = charset;
        this.load(new FileResource(propertiesFile));
    }

    public Properties(String path, Class<?> clazz) {
        this(path, clazz, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(String path, Class<?> clazz, String charsetName) {
        this(path, clazz, org.aoju.bus.core.lang.Charset.charset(charsetName));
    }

    public Properties(String path, Class<?> clazz, Charset charset) {
        Assert.notBlank(path, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(new ClassPathResource(path, clazz));
    }

    public Properties(URL propertiesUrl) {
        this(propertiesUrl, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, org.aoju.bus.core.lang.Charset.charset(charsetName));
    }

    public Properties(URL propertiesUrl, Charset charset) {
        Assert.notNull(propertiesUrl, "Null properties URL !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(new UriResource(propertiesUrl));
    }

    public Properties(java.util.Properties properties) {
        if (CollKit.isNotEmpty(properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public static java.util.Properties getProp(String resource) {
        return new Properties(resource);
    }

    public static java.util.Properties getProp(String resource, String charsetName) {
        return new Properties(resource, charsetName);
    }

    public static java.util.Properties getProp(String resource, Charset charset) {
        return new Properties(resource, charset);
    }

    public static java.util.Properties getProp(String resource, Class<?> clazz) {
        return new Properties(resource, clazz);
    }

    public void load(URL url) {
        this.load(new UriResource(url));
    }

    public void load(Resource resource) {
        Assert.notNull(resource, "Props resource must be not null!", new Object[0]);
        this.resource = resource;
        try (BufferedReader reader = resource.getReader(this.charset);){
            super.load(reader);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull(this.resource, "Properties resource must be not null!", new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchKit.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Properties.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoKit.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        return this.getString(key, null == defaultValue ? null : defaultValue.toString());
    }

    @Override
    public Object getObject(String key) {
        return this.getObject(key, (Object)null);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        return super.getProperty(key);
    }

    @Override
    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt(this.getString(key), defaultValue);
    }

    @Override
    public Integer getInt(String key) {
        return this.getInt(key, (Integer)null);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return Convert.toBoolean(this.getString(key), defaultValue);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, (Boolean)null);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong(this.getString(key), defaultValue);
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, (Long)null);
    }

    @Override
    public Character getChar(String key, Character defaultValue) {
        String value = this.getString(key);
        if (StringKit.isBlank(value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public Character getChar(String key) {
        return this.getChar(key, (Character)null);
    }

    @Override
    public Float getFloat(String key) {
        return this.getFloat(key, (Float)null);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat(this.getString(key), defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble(this.getString(key), defaultValue);
    }

    @Override
    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, (Double)null);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort(this.getString(key), defaultValue);
    }

    @Override
    public Short getShort(String key) {
        return this.getShort(key, (Short)null);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte(this.getString(key), defaultValue);
    }

    @Override
    public Byte getByte(String key) {
        return this.getByte(key, (Byte)null);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getString(key);
        if (StringKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, (BigDecimal)null);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getString(key);
        if (StringKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, (BigInteger)null);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return Convert.toEnum(clazz, this.getString(key), defaultValue);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, (E)null);
    }

    @Override
    public Date getDate(String key, Date defaultValue) {
        return Convert.toDate(this.getString(key), defaultValue);
    }

    @Override
    public Date getDate(String key) {
        return this.getDate(key, (Date)null);
    }

    public String getAndRemoveString(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public java.util.Properties toProperties() {
        java.util.Properties properties = new java.util.Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        T bean = ReflectKit.newInstanceIfPossible(beanClass);
        return this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StringKit.nullToEmpty(StringKit.addSuffixIfNot(prefix, "."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringKit.startWith((CharSequence)key, prefix)) continue;
            try {
                BeanKit.setProperty(bean, StringKit.subSuf(key, prefix.length()), entry.getValue());
            }
            catch (Exception e) {
                Logger.debug("Ignore property: [{}]", key);
            }
        }
        return bean;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) throws InternalException {
        BufferedWriter writer = null;
        try {
            writer = FileKit.getWriter(absolutePath, this.charset, false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new InternalException("Store properties to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoKit.close(writer);
                throw throwable;
            }
        }
        IoKit.close(writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileKit.getAbsolutePath(path, clazz));
    }
}

