/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.lang.reflect.Field;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.buffer.ByteBuffer;
import org.aoju.bus.core.io.buffer.PageBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.AioQuickServer;
import org.aoju.bus.socket.QuickTimer;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public class PageBufferPlugin<T>
extends AbstractPlugin {
    private final AioQuickServer<T> server;
    private int seconds = 0;
    private ScheduledFuture<?> future;

    public PageBufferPlugin(AioQuickServer<T> server, int seconds) {
        this.seconds = seconds;
        this.server = server;
        this.init();
    }

    private void init() {
        long mills = TimeUnit.SECONDS.toMillis(this.seconds);
        this.future = QuickTimer.scheduleAtFixedRate(() -> {
            if (null == this.server) {
                Logger.error("unKnow server or client need to monitor!", new Object[0]);
                this.shutdown();
                return;
            }
            try {
                Field bufferPoolField = AioQuickServer.class.getDeclaredField("bufferPool");
                bufferPoolField.setAccessible(true);
                ByteBuffer pagePool = (ByteBuffer)bufferPoolField.get(this.server);
                if (null == pagePool) {
                    Logger.error("server maybe has not started!", new Object[0]);
                    this.shutdown();
                    return;
                }
                Field field = ByteBuffer.class.getDeclaredField("pageBuffers");
                field.setAccessible(true);
                PageBuffer[] pages = (PageBuffer[])field.get(pagePool);
                Object logger = "";
                for (PageBuffer page : pages) {
                    logger = (String)logger + "\r\n" + page.toString();
                }
                Logger.info((String)logger, new Object[0]);
            }
            catch (Exception e) {
                Logger.error("", e);
            }
        }, mills, mills);
    }

    private void shutdown() {
        if (null != this.future) {
            this.future.cancel(true);
            this.future = null;
        }
    }
}

