/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.limiter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.limiter.Handler;
import org.aoju.bus.limiter.Parser;
import org.aoju.bus.limiter.Resolver;
import org.aoju.bus.limiter.intercept.BeanFactoryLimitedResourceSourceAdvisor;
import org.aoju.bus.limiter.intercept.LimiterInterceptor;
import org.aoju.bus.limiter.resource.DefaultLimitedResourceSource;
import org.aoju.bus.limiter.resource.LimitedResourceSource;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.limiter.AbstractLimiterAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.core.io.ResourceLoader;

@Role(value=2)
public class LimiterAwareHandler
extends AbstractLimiterAware
implements ResourceLoaderAware {
    ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Bean
    @Role(value=2)
    public BeanFactoryLimitedResourceSourceAdvisor limiterAdvisor(LimitedResourceSource limitedResourceSource, LimiterInterceptor limiterInterceptor) {
        BeanFactoryLimitedResourceSourceAdvisor advisor = new BeanFactoryLimitedResourceSourceAdvisor(limitedResourceSource);
        advisor.setAdvice(limiterInterceptor);
        if (null != this.enableLimiter) {
            advisor.setOrder((Integer)this.enableLimiter.getNumber("order"));
        }
        return advisor;
    }

    @Bean
    @Role(value=2)
    public LimitedResourceSource limitedResourceSource() {
        int i;
        String[] parsersClassNames = this.enableLimiter.getStringArray("annotationParser");
        List<String> defaultParsers = this.findDefaultParsers();
        if (!CollKit.isEmpty(defaultParsers)) {
            int len = parsersClassNames.length;
            parsersClassNames = Arrays.copyOf(parsersClassNames, parsersClassNames.length + defaultParsers.size());
            for (i = 0; i < defaultParsers.size(); ++i) {
                parsersClassNames[i + len] = defaultParsers.get(i);
            }
        }
        Parser[] parsers = new Parser[parsersClassNames.length];
        for (i = 0; i < parsersClassNames.length; ++i) {
            try {
                Class<?> parserClass = Class.forName(parsersClassNames[i]);
                parsers[i] = (Parser)parserClass.newInstance();
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new InternalException("Class Not Found!");
            }
        }
        return new DefaultLimitedResourceSource(parsers);
    }

    @Bean
    @Role(value=2)
    public LimiterInterceptor limiterInterceptor(LimitedResourceSource limitedResourceSource) {
        LimiterInterceptor interceptor = new LimiterInterceptor();
        interceptor.setLimitedResourceSource(limitedResourceSource);
        return interceptor;
    }

    @Bean
    Handler defaultErrorHandler() {
        Handler errorHandler = (throwable, executionContext) -> {
            Logger.info(throwable.getMessage(), new Object[0]);
            throw new RuntimeException(throwable.getMessage());
        };
        return errorHandler;
    }

    @Bean
    Resolver defaultFallbackResolver() {
        Resolver<Object> limitedFallbackResolver = (method, clazz, args, limitedResource, target) -> {
            throw new RuntimeException("no message available");
        };
        return limitedFallbackResolver;
    }

    private List<String> findDefaultParsers() {
        String[] parsers = new String[]{"LockAnnotationParser", "RateLimiterAnnotationParser", "PeakLimiterAnnotationParser"};
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < parsers.length; ++i) {
            try {
                Class.forName(parsers[i]);
                ret.add(parsers[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ret;
    }
}

