/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.mapper.handler.AbstractSqlHandler;
import org.apache.ibatis.reflection.MetaObject;

public abstract class AbstractSqlParserHandler
extends AbstractSqlHandler {
    public String parser(MetaObject metaObject, String sql) {
        if (this.allowProcess(metaObject)) {
            try {
                Logger.debug("Original SQL: " + sql, new Object[0]);
                StringBuilder sqlStringBuilder = new StringBuilder();
                Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
                int i = 0;
                for (Statement statement : statements.getStatements()) {
                    if (null == statement) continue;
                    if (i++ > 0) {
                        sqlStringBuilder.append(';');
                    }
                    sqlStringBuilder.append(this.processParser(statement));
                }
                if (sqlStringBuilder.length() > 0) {
                    return sqlStringBuilder.toString();
                }
            }
            catch (JSQLParserException e) {
                throw new InternalException("Failed to process, please exclude the tableName or statementId.\n Error SQL: %s", new Object[]{e, sql});
            }
        }
        return null;
    }

    public String processParser(Statement statement) {
        if (statement instanceof Insert) {
            this.processInsert((Insert)statement);
        } else if (statement instanceof Select) {
            this.processSelectBody(((Select)statement).getSelectBody());
        } else if (statement instanceof Update) {
            this.processUpdate((Update)statement);
        } else if (statement instanceof Delete) {
            this.processDelete((Delete)statement);
        }
        if (Logger.isDebug()) {
            Logger.debug("Parser SQL: " + statement.toString(), new Object[0]);
        }
        return statement.toString();
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (null != withItem.getSubSelect().getSelectBody()) {
                this.processSelectBody(withItem.getSubSelect().getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (null != operationList.getSelects() && operationList.getSelects().size() > 0) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    public boolean allowProcess(MetaObject metaObject) {
        return true;
    }

    public boolean doFilter(MetaObject metaObject, String sql) {
        return true;
    }

    public void processInsert(Insert insert) {
    }

    public void processDelete(Delete delete) {
        Assert.notNull(delete.getWhere(), "Prohibition of full table deletion", new Object[0]);
    }

    public void processUpdate(Update update) {
        Assert.notNull(update.getWhere(), "Prohibition of table update operation", new Object[0]);
    }
}

