/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.spring.PlaceBinder;
import org.aoju.bus.starter.annotation.EnableMapper;
import org.aoju.bus.starter.mapper.ClassPathMapperScanner;
import org.aoju.bus.starter.mapper.MapperFactoryBean;
import org.aoju.bus.starter.mapper.MybatisProperties;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
        super.registerBeanDefinitions(importingClassMetadata, registry, importBeanNameGenerator);
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        Class annotationClass;
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(EnableMapper.class.getName()));
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (!Annotation.class.equals((Object)(annotationClass = annoAttrs.getClass("annotationClass")))) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            scanner.setBeanNameGenerator((BeanNameGenerator)ReflectKit.newInstanceIfPossible(generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            scanner.setMapperFactoryBean((MapperFactoryBean)((Object)ReflectKit.newInstanceIfPossible(mapperFactoryBeanClass)));
        }
        scanner.setSqlSessionTemplateBeanName(annoAttrs.getString("sqlSessionTemplateRef"));
        scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String pkg : annoAttrs.getStringArray("value")) {
            if (!StringKit.hasText(pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : annoAttrs.getStringArray("basePackages")) {
            if (!StringKit.hasText(pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : annoAttrs.getClassArray("basePackageClasses")) {
            basePackages.add(ClassKit.getPackageName(clazz));
        }
        if (CollKit.isEmpty(basePackages)) {
            MybatisProperties properties = PlaceBinder.bind(this.environment, MybatisProperties.class, "extend.mybatis");
            if (properties != null && properties.getBasePackages() != null && properties.getBasePackages().length > 0) {
                basePackages.addAll(Arrays.asList(properties.getBasePackages()));
            } else {
                scanner.setAnnotationClass(Mapper.class);
            }
        }
        String mapperBuilderRef = annoAttrs.getString("mapperBuilderRef");
        String[] properties = annoAttrs.getStringArray("properties");
        if (StringKit.hasText(mapperBuilderRef)) {
            scanner.setMapperBuilderBeanName(mapperBuilderRef);
        } else if (properties != null && properties.length > 0) {
            scanner.setMapperProperties(properties);
        } else {
            scanner.setMapperProperties(this.environment);
        }
        scanner.registerFilters();
        scanner.doScan(ArrayKit.toArray(basePackages));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

