/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Item;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Builder;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Message;
import org.aoju.bus.storage.magic.Property;
import org.aoju.bus.storage.provider.AbstractProvider;

public class MinioOssProvider
extends AbstractProvider {
    private MinioClient client;

    public MinioOssProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.context.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.context.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.context.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getSecretKey(), "[secretKey] not defined", new Object[0]);
        Assert.notNull(this.context.isSecure(), "[secure] not defined", new Object[0]);
        Assert.notBlank(StringKit.toString(this.context.getReadTimeout()), "[readTimeout] not defined", new Object[0]);
        Assert.notBlank(StringKit.toString(this.context.getConnectTimeout()), "[connectTimeout] not defined", new Object[0]);
        Assert.notBlank(StringKit.toString(this.context.getWriteTimeout()), "[writeTimeout] not defined", new Object[0]);
        Assert.notBlank(StringKit.toString(this.context.getReadTimeout()), "[readTimeout] not defined", new Object[0]);
        this.client = MinioClient.builder().endpoint(this.context.getEndpoint()).credentials(this.context.getAccessKey(), this.context.getSecretKey()).build();
        this.client.setTimeout(Duration.ofSeconds(this.context.getConnectTimeout() != 0L ? this.context.getConnectTimeout() : 10L).toMillis(), Duration.ofSeconds(this.context.getWriteTimeout() != 60L ? this.context.getWriteTimeout() : 60L).toMillis(), Duration.ofSeconds(this.context.getReadTimeout() != 0L ? this.context.getReadTimeout() : 10L).toMillis());
    }

    @Override
    public Message download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Message download(String bucket, String fileName) {
        try {
            GetObjectResponse inputStream = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(fileName)).build());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(bufferedReader).build();
        }
        catch (Exception e) {
            Logger.error("file download failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message download(String bucket, String fileName, File file) {
        try {
            GetObjectResponse inputStream = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(fileName)).build());
            FileOutputStream outputStream = new FileOutputStream(file);
            IoKit.copy((InputStream)inputStream, outputStream);
        }
        catch (Exception e) {
            Logger.error("file download failed", e.getMessage());
        }
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Message list() {
        Iterable iterable = this.client.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.context.getBucket())).build());
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(StreamSupport.stream(iterable.spliterator(), true).map(itemResult -> {
            try {
                Property storageItem = new Property();
                Item item = (Item)itemResult.get();
                storageItem.setName(item.objectName());
                storageItem.setSize(StringKit.toString(item.size()));
                HashMap<String, Object> extend = new HashMap<String, Object>();
                extend.put("tag", item.etag());
                extend.put("storageClass", item.storageClass());
                extend.put("lastModified", item.lastModified());
                storageItem.setExtend(extend);
                return storageItem;
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
            }
            catch (ServerException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidResponseException e) {
                throw new RuntimeException(e);
            }
            catch (XmlParserException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList())).build();
    }

    @Override
    public Message rename(String oldName, String newName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message rename(String bucket, String oldName, String newName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message upload(String bucket, byte[] content) {
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        return this.upload(this.context.getBucket(), bucket, stream);
    }

    @Override
    public Message upload(String bucket, String fileName, InputStream content) {
        try {
            this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(fileName)).stream(content, (long)content.available(), -1L).contentType("application/octet-stream").build());
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(Property.builder().name(fileName).path(this.context.getPrefix() + fileName)).build();
        }
        catch (Exception e) {
            Logger.error("file upload failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message upload(String bucket, String fileName, byte[] content) {
        return this.upload(bucket, fileName, new ByteArrayInputStream(content));
    }

    @Override
    public Message remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Message remove(String bucket, String fileName) {
        try {
            this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(fileName)).build());
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (Exception e) {
            Logger.error("file remove failed ", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

