/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2022 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.office.excel.sax;

import org.xml.sax.Attributes;

/**
 * Excel的XML中属性名枚举
 *
 * @author Kimi Liu
 * @since Java 17+
 */
public enum AttributeName {

    /**
     * 行列号属性，行标签下此为行号属性名，cell标签下下为列号属性名
     */
    r,
    /**
     * ST（StylesTable） 的索引，样式index，用于获取行或单元格样式
     */
    s,
    /**
     * Type类型，单元格类型属性，见{@link CellDataType}
     */
    t;

    /**
     * 是否匹配给定属性
     *
     * @param attributeName 属性
     * @return 是否匹配
     */
    public boolean match(String attributeName) {
        return this.name().equals(attributeName);
    }

    /**
     * 从属性里列表中获取对应属性值
     *
     * @param attributes 属性列表
     * @return 属性值
     */
    public String getValue(Attributes attributes) {
        return attributes.getValue(name());
    }

}
