/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDesc;
import org.aoju.bus.core.beans.copier.AbstractCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.mutable.MutableEntry;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.map.MapWrapper;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class MapToBeanCopier<T>
extends AbstractCopier<Map<?, ?>, T> {
    private final Type targetType;

    public MapToBeanCopier(Map<?, ?> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        Object raw;
        if (source instanceof MapWrapper && (raw = ((MapWrapper)source).getRaw()) instanceof CaseInsensitiveMap) {
            copyOptions.setIgnoreCase(true);
        }
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropertyDesc> targetPropDescMap = BeanKit.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            MutableEntry<String, Object> entry = this.copyOptions.editField(sKey.toString(), sValue);
            if (null == entry) {
                return;
            }
            String sFieldName = entry.getKey();
            if (null == sFieldName) {
                return;
            }
            PropertyDesc tDesc = this.findPropDesc(targetPropDescMap, sFieldName);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Object newValue = entry.getValue();
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), newValue)) {
                return;
            }
            Type fieldType = TypeKit.getActualType(this.targetType, tDesc.getFieldType());
            newValue = this.copyOptions.convertField(fieldType, newValue);
            tDesc.setValue(this.target, newValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }

    private PropertyDesc findPropDesc(Map<String, PropertyDesc> map, String key) {
        PropertyDesc propDesc = map.get(key);
        if (null != propDesc) {
            return propDesc;
        }
        propDesc = map.get(key = StringKit.toCamelCase(key));
        if (null != propDesc) {
            return propDesc;
        }
        if (key.startsWith("is")) {
            key = StringKit.removePreAndLowerFirst((CharSequence)key, 2);
            propDesc = map.get(key);
            return propDesc;
        }
        return null;
    }
}

