/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.lang.function.XMultiple;

public class GenericBuilder<T>
implements Builder<T> {
    private static final long serialVersionUID = 1L;
    private final Supplier<T> instant;
    private final List<Consumer<T>> modifiers = new ArrayList<Consumer<T>>();

    public GenericBuilder(Supplier<T> instant) {
        this.instant = instant;
    }

    public static <T> GenericBuilder<T> of(Supplier<T> instant) {
        return new GenericBuilder<T>(instant);
    }

    public GenericBuilder<T> with(Consumer<T> consumer) {
        this.modifiers.add(consumer);
        return this;
    }

    public <P1> GenericBuilder<T> with(BiConsumer<T, P1> consumer, P1 p1) {
        this.modifiers.add(instant -> consumer.accept(instant, p1));
        return this;
    }

    public <P1, P2> GenericBuilder<T> with(XMultiple<T, P1, P2> consumer, P1 p1, P2 p2) {
        this.modifiers.add(instant -> consumer.accept(instant, p1, p2));
        return this;
    }

    @Override
    public T build() {
        Object value = this.instant.get();
        this.modifiers.forEach(modifier -> modifier.accept(value));
        this.modifiers.clear();
        return value;
    }
}

