/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.aoju.bus.core.map.MapBuilder;
import org.aoju.bus.core.toolkit.ObjectKit;

public class UniqueKeySet<K, V>
extends AbstractSet<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Function<V, K> uniqueGenerator;
    private Map<K, V> map;

    public UniqueKeySet(Function<V, K> uniqueGenerator) {
        this(false, uniqueGenerator);
    }

    public UniqueKeySet(boolean isLinked, Function<V, K> uniqueGenerator) {
        this(MapBuilder.create(isLinked), uniqueGenerator);
    }

    public UniqueKeySet(Function<V, K> uniqueGenerator, Collection<? extends V> c) {
        this(false, uniqueGenerator, c);
    }

    public UniqueKeySet(int initialCapacity, float loadFactor, Function<V, K> uniqueGenerator) {
        this(MapBuilder.create(new HashMap(initialCapacity, loadFactor)), uniqueGenerator);
    }

    public UniqueKeySet(boolean isLinked, Function<V, K> uniqueGenerator, Collection<? extends V> c) {
        this(isLinked, uniqueGenerator);
        this.addAll(c);
    }

    public UniqueKeySet(MapBuilder<K, V> builder, Function<V, K> uniqueGenerator) {
        this.map = builder.build();
        this.uniqueGenerator = uniqueGenerator;
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(this.uniqueGenerator.apply(o));
    }

    @Override
    public boolean add(V v) {
        return null == this.map.put(this.uniqueGenerator.apply(v), v);
    }

    public boolean addIfAbsent(V v) {
        return null == this.map.putIfAbsent(this.uniqueGenerator.apply(v), v);
    }

    public boolean addAllIfAbsent(Collection<? extends V> c) {
        boolean modified = false;
        for (V v : c) {
            if (!this.addIfAbsent(v)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        return null != this.map.remove(this.uniqueGenerator.apply(o));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public UniqueKeySet<K, V> clone() {
        try {
            UniqueKeySet newSet = (UniqueKeySet)super.clone();
            newSet.map = ObjectKit.clone(this.map);
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

