/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compare;

import java.lang.reflect.Field;
import org.aoju.bus.core.compare.FuncCompare;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class FieldCompare<T>
extends FuncCompare<T> {
    private static final long serialVersionUID = 1L;

    public FieldCompare(Class<T> beanClass, String fieldName) {
        this(FieldCompare.getNonNullField(beanClass, fieldName));
    }

    public FieldCompare(Field field) {
        this(true, field);
    }

    public FieldCompare(boolean nullGreater, Field field) {
        super(nullGreater, (T bean) -> (Comparable)ReflectKit.getFieldValue(bean, Assert.notNull(field, "Field must be not null!", new Object[0])));
    }

    private static Field getNonNullField(Class<?> beanClass, String fieldName) {
        Field field = ClassKit.getDeclaredField(beanClass, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(StringKit.format((CharSequence)"Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
        return field;
    }
}

