/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compress;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.ZipKit;

public class ZipReader
implements Closeable {
    private ZipFile zipFile;
    private ZipInputStream in;

    public ZipReader(File zipFile, Charset charset) {
        this.zipFile = ZipKit.zipFile(zipFile, charset);
    }

    public ZipReader(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipReader(InputStream in, Charset charset) {
        this.in = new ZipInputStream(in, charset);
    }

    public ZipReader(ZipInputStream zin) {
        this.in = zin;
    }

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(zipFile, charset);
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(in, charset);
    }

    public InputStream get(String path) {
        if (null != this.zipFile) {
            ZipFile zipFile = this.zipFile;
            ZipEntry entry = zipFile.getEntry(path);
            if (null != entry) {
                return ZipKit.get(zipFile, entry);
            }
        } else {
            try {
                ZipEntry zipEntry;
                this.in.reset();
                while (null != (zipEntry = this.in.getNextEntry())) {
                    if (!zipEntry.getName().equals(path)) continue;
                    return this.in;
                }
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        return null;
    }

    public File readTo(File outFile) throws InternalException {
        return this.readTo(outFile, null);
    }

    public File readTo(File outFile, Predicate<ZipEntry> entryFilter) throws InternalException {
        this.read(zipEntry -> {
            if (null == entryFilter || entryFilter.test((ZipEntry)zipEntry)) {
                String path = zipEntry.getName();
                if (FileKit.isWindows()) {
                    path = StringKit.replace((CharSequence)path, (CharSequence)"*", "_");
                }
                File outItemFile = FileKit.file(outFile, path);
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                } else {
                    InputStream in = null != this.zipFile ? ZipKit.get(this.zipFile, zipEntry) : this.in;
                    FileKit.writeFromStream(in, outItemFile, false);
                }
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws InternalException {
        if (null != this.zipFile) {
            this.readFromZipFile(consumer);
        } else {
            this.readFromStream(consumer);
        }
        return this;
    }

    @Override
    public void close() throws InternalException {
        if (null != this.zipFile) {
            IoKit.close(this.zipFile);
        } else {
            IoKit.close(this.in);
        }
    }

    private void readFromZipFile(Consumer<ZipEntry> consumer) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(em.nextElement());
        }
    }

    private void readFromStream(Consumer<ZipEntry> consumer) throws InternalException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

