/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Enums;
import org.aoju.bus.core.map.WeakMap;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.EnumKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class EnumConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final EnumConverter INSTANCE = new EnumConverter();
    private static final WeakMap<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new WeakMap();

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        Enums first;
        if (value == null) {
            return null;
        }
        if (Enums.class.isAssignableFrom(enumClass) && null != (first = (Enums)EnumKit.getEnumAt(enumClass, 0))) {
            if (value instanceof Integer) {
                return (Enum)first.from((Integer)value);
            }
            if (value instanceof String) {
                return (Enum)first.from(value.toString());
            }
        }
        try {
            Map<Class<?>, Method> methodMap = EnumConverter.getMethodMap(enumClass);
            if (MapKit.isNotEmpty(methodMap)) {
                Class<?> valueClass = value.getClass();
                for (Map.Entry<Class<?>, Method> entry : methodMap.entrySet()) {
                    if (!ClassKit.isAssignable(entry.getKey(), valueClass)) continue;
                    return (Enum)ReflectKit.invokeStatic(entry.getValue(), value);
                }
            }
        }
        catch (Exception methodMap) {
            // empty catch block
        }
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)EnumKit.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getMethodMap(Class<?> enumClass) {
        return VALUE_OF_METHOD_CACHE.computeIfAbsent(enumClass, key -> Arrays.stream(enumClass.getMethods()).filter(BeanKit::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> !"valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (k1, k2) -> k1)));
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, targetClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(targetClass, this.convertToString(value));
        }
        if (null != enumValue) {
            return enumValue;
        }
        throw new ConvertException("Can not convert {} to {}", value, targetClass);
    }
}

