/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import org.aoju.bus.core.convert.AtomicBooleanConverter;
import org.aoju.bus.core.convert.AtomicIntegerArrayConverter;
import org.aoju.bus.core.convert.AtomicLongArrayConverter;
import org.aoju.bus.core.convert.AtomicReferenceConverter;
import org.aoju.bus.core.convert.BooleanConverter;
import org.aoju.bus.core.convert.CalendarConverter;
import org.aoju.bus.core.convert.CharacterConverter;
import org.aoju.bus.core.convert.CharsetConverter;
import org.aoju.bus.core.convert.ClassConverter;
import org.aoju.bus.core.convert.CompositeConverter;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.convert.CurrencyConverter;
import org.aoju.bus.core.convert.DateConverter;
import org.aoju.bus.core.convert.DurationConverter;
import org.aoju.bus.core.convert.LocaleConverter;
import org.aoju.bus.core.convert.OptionalConverter;
import org.aoju.bus.core.convert.PathConverter;
import org.aoju.bus.core.convert.PeriodConverter;
import org.aoju.bus.core.convert.ReferenceConverter;
import org.aoju.bus.core.convert.StackTraceConverter;
import org.aoju.bus.core.convert.StringConverter;
import org.aoju.bus.core.convert.TemporalConverter;
import org.aoju.bus.core.convert.TimeZoneConverter;
import org.aoju.bus.core.convert.URIConverter;
import org.aoju.bus.core.convert.URLConverter;
import org.aoju.bus.core.convert.UUIDConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Optional;

public class RegistryConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Type, Converter> defaultConverterMap;
    private volatile Map<Type, Converter> customConverterMap;

    public RegistryConverter() {
        this.register();
    }

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryConverter putCustom(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegistryConverter registryConverter = this;
            synchronized (registryConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    private void register() {
        this.defaultConverterMap = new ConcurrentHashMap<Type, Converter>();
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        this.defaultConverterMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)URI.class), new URIConverter());
        this.defaultConverterMap.put((Type)((Object)URL.class), new URLConverter());
        this.defaultConverterMap.put((Type)((Object)Calendar.class), new CalendarConverter());
        this.defaultConverterMap.put((Type)((Object)java.util.Date.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)DateTime.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Date.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Time.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Timestamp.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)TemporalAccessor.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Instant.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)LocalDateTime.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)LocalDate.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)LocalTime.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)ZonedDateTime.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)OffsetDateTime.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)OffsetTime.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)DayOfWeek.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Month.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)MonthDay.class), TemporalConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Period.class), new PeriodConverter());
        this.defaultConverterMap.put((Type)((Object)Duration.class), new DurationConverter());
        this.defaultConverterMap.put((Type)((Object)WeakReference.class), ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)SoftReference.class), ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicIntegerArray.class), new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicLongArray.class), new AtomicLongArrayConverter());
        this.defaultConverterMap.put((Type)((Object)Class.class), new ClassConverter());
        this.defaultConverterMap.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        this.defaultConverterMap.put((Type)((Object)Locale.class), new LocaleConverter());
        this.defaultConverterMap.put((Type)((Object)Charset.class), new CharsetConverter());
        this.defaultConverterMap.put((Type)((Object)Path.class), new PathConverter());
        this.defaultConverterMap.put((Type)((Object)Currency.class), new CurrencyConverter());
        this.defaultConverterMap.put((Type)((Object)UUID.class), new UUIDConverter());
        this.defaultConverterMap.put((Type)((Object)StackTraceElement.class), new StackTraceConverter());
        this.defaultConverterMap.put((Type)((Object)Optional.class), new OptionalConverter());
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

