/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class TemporalConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final TemporalConverter INSTANCE = new TemporalConverter();
    private String format;

    public TemporalConverter() {
        this(null);
    }

    public TemporalConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected TemporalAccessor convertInternal(Class<?> targetClass, Object value) {
        if (value instanceof Long) {
            return this.parseFromLong(targetClass, (Long)value);
        }
        if (value instanceof Integer) {
            return this.parseFromLong(targetClass, ((Integer)value).longValue());
        }
        if (value instanceof TemporalAccessor) {
            return this.parseFromTemporalAccessor(targetClass, (TemporalAccessor)value);
        }
        if (value instanceof Date) {
            DateTime dateTime = DateKit.date((Date)value);
            return this.parseFromInstant(targetClass, dateTime.toInstant(), dateTime.getZoneId());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.parseFromInstant(targetClass, calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        return this.parseFromCharSequence(targetClass, this.convertToString(value));
    }

    private TemporalAccessor parseFromCharSequence(Class<?> targetClass, CharSequence value) {
        ZoneId zoneId;
        Instant instant;
        if (StringKit.isBlank(value)) {
            return null;
        }
        if (DayOfWeek.class == targetClass) {
            return DayOfWeek.valueOf(StringKit.toString(value));
        }
        if (Month.class == targetClass) {
            return Month.valueOf(StringKit.toString(value));
        }
        if (Era.class == targetClass) {
            return IsoEra.valueOf(StringKit.toString(value));
        }
        if (MonthDay.class == targetClass) {
            return MonthDay.parse(value);
        }
        if (null != this.format) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.format);
            instant = formatter.parse(value, Instant::from);
            zoneId = formatter.getZone();
        } else {
            DateTime dateTime = DateKit.parse(value);
            instant = Objects.requireNonNull(dateTime).toInstant();
            zoneId = dateTime.getZoneId();
        }
        return this.parseFromInstant(targetClass, instant, zoneId);
    }

    private TemporalAccessor parseFromLong(Class<?> targetClass, Long time) {
        if (targetClass == Month.class) {
            return Month.of(Math.toIntExact(time));
        }
        if (targetClass == DayOfWeek.class) {
            return DayOfWeek.of(Math.toIntExact(time));
        }
        if (Era.class == targetClass) {
            return IsoEra.of(Math.toIntExact(time));
        }
        return this.parseFromInstant(targetClass, Instant.ofEpochMilli(time), null);
    }

    private TemporalAccessor parseFromTemporalAccessor(Class<?> targetClass, TemporalAccessor temporalAccessor) {
        if (DayOfWeek.class == targetClass) {
            return DayOfWeek.from(temporalAccessor);
        }
        if (Month.class == targetClass) {
            return Month.from(temporalAccessor);
        }
        if (MonthDay.class == targetClass) {
            return MonthDay.from(temporalAccessor);
        }
        TemporalAccessor result = null;
        if (temporalAccessor instanceof LocalDateTime) {
            result = this.parseFromLocalDateTime(targetClass, (LocalDateTime)temporalAccessor);
        } else if (temporalAccessor instanceof ZonedDateTime) {
            result = this.parseFromZonedDateTime(targetClass, (ZonedDateTime)temporalAccessor);
        }
        if (null == result) {
            result = this.parseFromInstant(targetClass, DateKit.toInstant(temporalAccessor), null);
        }
        return result;
    }

    private TemporalAccessor parseFromLocalDateTime(Class<?> targetClass, LocalDateTime localDateTime) {
        if (Instant.class.equals(targetClass)) {
            return DateKit.toInstant(localDateTime);
        }
        if (LocalDate.class.equals(targetClass)) {
            return localDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(targetClass)) {
            return localDateTime.toLocalTime();
        }
        if (ZonedDateTime.class.equals(targetClass)) {
            return localDateTime.atZone(ZoneId.systemDefault());
        }
        if (OffsetDateTime.class.equals(targetClass)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (OffsetTime.class.equals(targetClass)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromZonedDateTime(Class<?> targetClass, ZonedDateTime zonedDateTime) {
        if (Instant.class.equals(targetClass)) {
            return DateKit.toInstant(zonedDateTime);
        }
        if (LocalDateTime.class.equals(targetClass)) {
            return zonedDateTime.toLocalDateTime();
        }
        if (LocalDate.class.equals(targetClass)) {
            return zonedDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(targetClass)) {
            return zonedDateTime.toLocalTime();
        }
        if (OffsetDateTime.class.equals(targetClass)) {
            return zonedDateTime.toOffsetDateTime();
        }
        if (OffsetTime.class.equals(targetClass)) {
            return zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromInstant(Class<?> targetClass, Instant instant, ZoneId zoneId) {
        if (Instant.class.equals(targetClass)) {
            return instant;
        }
        zoneId = ObjectKit.defaultIfNull(zoneId, ZoneId::systemDefault);
        Comparable<ChronoLocalDateTime<?>> result = null;
        if (LocalDateTime.class.equals(targetClass)) {
            result = LocalDateTime.ofInstant(instant, zoneId);
        } else if (LocalDate.class.equals(targetClass)) {
            result = instant.atZone(zoneId).toLocalDate();
        } else if (LocalTime.class.equals(targetClass)) {
            result = instant.atZone(zoneId).toLocalTime();
        } else if (ZonedDateTime.class.equals(targetClass)) {
            result = instant.atZone(zoneId);
        } else if (OffsetDateTime.class.equals(targetClass)) {
            result = OffsetDateTime.ofInstant(instant, zoneId);
        } else if (OffsetTime.class.equals(targetClass)) {
            result = OffsetTime.ofInstant(instant, zoneId);
        }
        return result;
    }
}

