/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.formatter;

import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.StringKit;

public class DatePeriod {
    private final int maxCount;
    private long betweenMs;
    private Fields.Units unit;

    public DatePeriod(long betweenMs, Fields.Units units) {
        this(betweenMs, units, 0);
    }

    public DatePeriod(long betweenMs, Fields.Units unit, int maxCount) {
        this.betweenMs = betweenMs;
        this.unit = unit;
        this.maxCount = maxCount;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        if (this.betweenMs > 0L) {
            long day = this.betweenMs / Fields.Units.DAY.getUnit();
            long hour = this.betweenMs / Fields.Units.HOUR.getUnit() - day * 24L;
            long minute = this.betweenMs / Fields.Units.MINUTE.getUnit() - day * 24L * 60L - hour * 60L;
            long second = this.betweenMs / Fields.Units.SECOND.getUnit() - ((day * 24L + hour) * 60L + minute) * 60L;
            long millisecond = this.betweenMs - (((day * 24L + hour) * 60L + minute) * 60L + second) * 1000L;
            int level = this.unit.ordinal();
            int unitCount = 0;
            if (this.isUnitCountValid(unitCount) && 0L != day && level >= Fields.Units.DAY.ordinal()) {
                sb.append(day).append(Fields.Units.DAY.getName());
                ++unitCount;
            }
            if (this.isUnitCountValid(unitCount) && 0L != hour && level >= Fields.Units.HOUR.ordinal()) {
                sb.append(hour).append(Fields.Units.HOUR.getName());
                ++unitCount;
            }
            if (this.isUnitCountValid(unitCount) && 0L != minute && level >= Fields.Units.MINUTE.ordinal()) {
                sb.append(minute).append(Fields.Units.MINUTE.getName());
                ++unitCount;
            }
            if (this.isUnitCountValid(unitCount) && 0L != second && level >= Fields.Units.SECOND.ordinal()) {
                sb.append(second).append(Fields.Units.SECOND.getName());
                ++unitCount;
            }
            if (this.isUnitCountValid(unitCount) && 0L != millisecond && level >= Fields.Units.MILLISECOND.ordinal()) {
                sb.append(millisecond).append(Fields.Units.MILLISECOND.getName());
                ++unitCount;
            }
        }
        if (StringKit.isEmpty(sb)) {
            sb.append(0).append(this.unit.getName());
        }
        return sb.toString();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public void setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
    }

    public Fields.Units getUnit() {
        return this.unit;
    }

    public void setUnit(Fields.Units unit) {
        this.unit = unit;
    }

    public String toString() {
        return this.format();
    }

    private boolean isUnitCountValid(int unitCount) {
        return this.maxCount <= 0 || unitCount < this.maxCount;
    }
}

