/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.painter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.TextElement;
import org.aoju.bus.core.image.painter.Painter;
import org.aoju.bus.core.lang.Scale;

public class TextPainter
implements Painter {
    @Override
    public void draw(Graphics2D g, AbstractElement element, int canvasWidth) {
        TextElement textElement = (TextElement)element;
        List<Object> textLineElements = new ArrayList<TextElement>();
        textLineElements.add(textElement);
        if (textElement.isAutoBreakLine()) {
            textLineElements = textElement.getBreakLineElements();
        }
        for (int i = 0; i < textLineElements.size(); ++i) {
            TextElement firstLineElement = (TextElement)textLineElements.get(0);
            TextElement currentLineElement = (TextElement)textLineElements.get(i);
            g.setFont(currentLineElement.getFont());
            g.setColor(currentLineElement.getColor());
            if (currentLineElement.isCenter()) {
                if (i == 0) {
                    currentLineElement.setX((canvasWidth - currentLineElement.getWidth()) / 2);
                } else {
                    switch (textElement.getAlign()) {
                        case LEFT: {
                            currentLineElement.setX(firstLineElement.getX());
                            break;
                        }
                        case CENTER: {
                            currentLineElement.setX((canvasWidth - currentLineElement.getWidth()) / 2);
                            break;
                        }
                        case RIGHT: {
                            currentLineElement.setX(firstLineElement.getX() + firstLineElement.getWidth() - currentLineElement.getWidth());
                        }
                    }
                }
            } else if (i == 0) {
                if (currentLineElement.getDirection() == Scale.Direction.RIGHT_LEFT) {
                    currentLineElement.setX(currentLineElement.getX() - currentLineElement.getWidth());
                } else if (currentLineElement.getDirection() == Scale.Direction.CENTER_LEFT_RIGHT) {
                    currentLineElement.setX(currentLineElement.getX() - currentLineElement.getWidth() / 2);
                }
            } else {
                switch (textElement.getAlign()) {
                    case LEFT: {
                        currentLineElement.setX(firstLineElement.getX());
                        break;
                    }
                    case CENTER: {
                        currentLineElement.setX(firstLineElement.getX() + (firstLineElement.getWidth() - currentLineElement.getWidth()) / 2);
                        break;
                    }
                    case RIGHT: {
                        currentLineElement.setX(firstLineElement.getX() + firstLineElement.getWidth() - currentLineElement.getWidth());
                    }
                }
            }
            if (currentLineElement.getRotate() != null) {
                g.rotate(Math.toRadians(currentLineElement.getRotate().intValue()), currentLineElement.getX() + currentLineElement.getWidth() / 2, currentLineElement.getDrawY().intValue());
            }
            g.setComposite(AlphaComposite.getInstance(3, currentLineElement.getAlpha()));
            if (currentLineElement.isStrikeThrough()) {
                AttributedString as = new AttributedString(currentLineElement.getText());
                as.addAttribute(TextAttribute.FONT, currentLineElement.getFont());
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, currentLineElement.getText().length());
                g.drawString(as.getIterator(), currentLineElement.getX(), (int)currentLineElement.getDrawY());
            } else {
                g.drawString(currentLineElement.getText(), currentLineElement.getX(), (int)currentLineElement.getDrawY());
            }
            if (currentLineElement.getRotate() == null) continue;
            g.rotate(-Math.toRadians(currentLineElement.getRotate().intValue()), currentLineElement.getX() + currentLineElement.getWidth() / 2, currentLineElement.getDrawY().intValue());
        }
    }

    @Override
    public void drawRepeat(Graphics2D g, AbstractElement element, int canvasWidth, int canvasHeight) {
        TextElement textElement = (TextElement)element;
        int currentX = element.getX();
        int currentY = element.getY();
        while (currentX > 0) {
            currentX = currentX - textElement.getHorizontal() - textElement.getWidth();
        }
        while (currentY > 0) {
            currentY = currentY - textElement.getVertical() - textElement.getHeight();
        }
        int startY = currentY;
        while (currentX < canvasWidth) {
            textElement.setX(currentX);
            currentX = currentX + textElement.getHorizontal() + textElement.getWidth();
            while (currentY < canvasHeight) {
                textElement.setY(currentY);
                currentY = currentY + textElement.getVertical() + textElement.getHeight();
                this.draw(g, textElement, canvasWidth);
            }
            currentY = startY;
        }
    }
}

