/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.copier;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.Progress;
import org.aoju.bus.core.io.copier.IoCopier;
import org.aoju.bus.core.lang.Assert;

public class ReaderWriterCopier
extends IoCopier<Reader, Writer> {
    public ReaderWriterCopier() {
        this(8192);
    }

    public ReaderWriterCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public ReaderWriterCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public ReaderWriterCopier(int bufferSize, long count, Progress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(Reader source, Writer target) {
        long size;
        Assert.notNull(source, "InputStream is null !", new Object[0]);
        Assert.notNull(target, "OutputStream is null !", new Object[0]);
        Progress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, new char[this.bufferSize(this.count)], progress);
            target.flush();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(Reader source, Writer target, char[] buffer, Progress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, this.bufferSize(numToRead))) >= 0) {
            target.write(buffer, 0, read);
            if (this.flushEveryBuffer) {
                target.flush();
            }
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(this.count, total);
        }
        return total;
    }
}

