/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.aoju.bus.core.exception.InternalException;

@FunctionalInterface
public interface XConsumer<T>
extends Consumer<T>,
Serializable {
    @SafeVarargs
    public static <T> XConsumer<T> multi(XConsumer<T> ... consumers) {
        return Stream.of(consumers).reduce(XConsumer::andThen).orElseGet(() -> o -> {});
    }

    public static <T> XConsumer<T> nothing() {
        return t -> {};
    }

    public void accepting(T var1) throws Exception;

    @Override
    default public void accept(T t) {
        try {
            this.accepting(t);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    @Override
    default public XConsumer<T> andThen(XConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }
}

