/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aoju.bus.core.exception.InternalException;

@FunctionalInterface
public interface XPredicate<T>
extends Predicate<T>,
Serializable {
    @SafeVarargs
    public static <T> XPredicate<T> multiAnd(XPredicate<T> ... predicates) {
        return Stream.of(predicates).reduce(XPredicate::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> XPredicate<T> multiOr(XPredicate<T> ... predicates) {
        return Stream.of(predicates).reduce(XPredicate::or).orElseGet(() -> o -> false);
    }

    public static <T> XPredicate<T> isEqual(Object ... targetRef) {
        return null == targetRef ? Objects::isNull : object -> Stream.of(targetRef).allMatch(target -> target.equals(object));
    }

    public boolean testing(T var1) throws Exception;

    @Override
    default public boolean test(T t) {
        try {
            return this.testing(t);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    @Override
    default public XPredicate<T> and(XPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Override
    default public XPredicate<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public XPredicate<T> or(XPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }
}

