/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.UriKit;

public class JarLoaders
extends URLClassLoader {
    public JarLoaders() {
        this(new URL[0]);
    }

    public JarLoaders(URL[] urls) {
        super(urls, ClassKit.getClassLoader());
    }

    public JarLoaders(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
    }

    public static JarLoaders load(File dir) {
        JarLoaders loader = new JarLoaders();
        loader.addJar(dir);
        loader.addURL(dir);
        return loader;
    }

    public static JarLoaders loadJar(File jarFile) {
        JarLoaders loader = new JarLoaders();
        try {
            loader.addJar(jarFile);
        }
        finally {
            IoKit.close(loader);
        }
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws InternalException {
        try {
            Method method = ClassKit.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarLoaders.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectKit.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarLoaders.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    private static List<File> loopJar(File file) {
        return FileKit.loopFiles(file, file1 -> {
            String path = file1.getPath();
            return null != path && path.toLowerCase().endsWith(".jar");
        });
    }

    private static boolean isJarFile(File file) {
        if (!FileKit.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }

    public JarLoaders addJar(File jarFile) {
        List<File> jars = JarLoaders.loopJar(jarFile);
        try {
            for (File jar : jars) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new InternalException(e);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarLoaders addURL(File dir) {
        super.addURL(UriKit.getURL(dir));
        return this;
    }
}

