/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lock.ObjectWithLock;

public class MapWithLock<K, V>
extends ObjectWithLock<Map<K, V>> {
    private static final long serialVersionUID = 1L;

    public MapWithLock() {
        this(new HashMap());
    }

    public MapWithLock(int initCapacity) {
        this(new HashMap(initCapacity));
    }

    public MapWithLock(Map<K, V> map) {
        super(map);
    }

    public MapWithLock(Map<K, V> map, ReentrantReadWriteLock lock) {
        super(map, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObject();
            V v = map.put(key, value);
            return v;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObject();
            V oldValue = map.putIfAbsent(key, value);
            if (null == oldValue) {
                V v = value;
                return v;
            }
            V v = oldValue;
            return v;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<K, V> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            ((Map)this.getObject()).putAll(map);
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObject();
            map.clear();
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObject();
            Object v = map.remove(key);
            return v;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Map map = (Map)this.getObject();
            Object v = map.get(key);
            return v;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Map map = (Map)this.getObject();
            int n = map.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public Map<K, V> copy() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            if (((Map)this.getObject()).size() > 0) {
                HashMap hashMap = new HashMap((Map)this.getObject());
                return hashMap;
            }
            Map<K, V> map = null;
            return map;
        }
        finally {
            readLock.unlock();
        }
    }
}

