/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.core.beans.PathExpression;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.getter.TypeGetter;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.function.XSupplier;
import org.aoju.bus.core.map.CustomKeyMap;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.LambdaKit;

public class Dictionary
extends CustomKeyMap<String, Object>
implements TypeGetter<String> {
    private static final long serialVersionUID = 1L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private boolean caseInsensitive;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dictionary(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dictionary(Map<String, Object> map) {
        super(null == map ? new HashMap() : map);
    }

    public Dictionary(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dictionary(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dictionary(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
        this.caseInsensitive = caseInsensitive;
    }

    public static Dictionary of() {
        return new Dictionary();
    }

    public static <T> Dictionary parse(T bean) {
        return Dictionary.of().parseBean(bean);
    }

    @SafeVarargs
    public static Dictionary ofEntries(Map.Entry<String, Object> ... pairs) {
        Dictionary dict = Dictionary.of();
        for (Map.Entry<String, Object> pair : pairs) {
            dict.put(pair.getKey(), pair.getValue());
        }
        return dict;
    }

    public static Dictionary ofKvs(Object ... keysAndValues) {
        Dictionary dict = Dictionary.of();
        String key = null;
        for (int i = 0; i < keysAndValues.length; ++i) {
            if (i % 2 == 0) {
                key = Convert.toString(keysAndValues[i]);
                continue;
            }
            dict.put(key, keysAndValues[i]);
        }
        return dict;
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanKit.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanKit.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanKit.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanKit.toBean(this, clazz);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanKit.toBean((Object)this, clazz, CopyOptions.of().setIgnoreCase(true));
    }

    public <T> Dictionary parseBean(T bean) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll(BeanKit.beanToMap(bean));
        return this;
    }

    public <T> Dictionary parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll(BeanKit.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dictionary> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollKit.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || !Objects.equals(value = this.get(entry.getKey()), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dictionary filter(String ... keys) {
        Dictionary result = new Dictionary(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Dictionary set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dictionary setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public <T> T getBean(String attr) {
        return (T)this.get(attr);
    }

    public <T> T getByPath(String expression) {
        return (T)PathExpression.create(expression).get(this);
    }

    public <T> T getByPath(String expression, Type resultType) {
        return Convert.convert(resultType, this.getByPath(expression));
    }

    @Override
    public Dictionary clone() {
        try {
            return (Dictionary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalException(e);
        }
    }

    @Override
    protected String customKey(Object key) {
        if (this.caseInsensitive && null != key) {
            key = ((String)key).toLowerCase();
        }
        return (String)key;
    }

    public Dictionary setFields(XSupplier<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaKit.getFieldName(f), f.get()));
        return this;
    }
}

