/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aoju.bus.core.annotation.Alias;
import org.aoju.bus.core.annotation.AnnoProxy;
import org.aoju.bus.core.annotation.Annotated;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.lang.function.XFunction;
import org.aoju.bus.core.scanner.AnnotationScanner;
import org.aoju.bus.core.scanner.Synthetic;
import org.aoju.bus.core.scanner.annotation.FieldScanner;
import org.aoju.bus.core.scanner.annotation.MetaScanner;
import org.aoju.bus.core.scanner.annotation.MethodScanner;
import org.aoju.bus.core.scanner.annotation.TypeScanner;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.LambdaKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class AnnoKit {
    static final Set<Class<? extends Annotation>> META_ANNOTATIONS = CollKit.newHashSet(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);

    public static boolean isJdkMetaAnnotation(Class<? extends Annotation> annotationType) {
        return META_ANNOTATIONS.contains(annotationType);
    }

    public static boolean isNotJdkMateAnnotation(Class<? extends Annotation> annotationType) {
        return false == AnnoKit.isJdkMetaAnnotation(annotationType);
    }

    public static Annotated toCombination(AnnotatedElement annotationEle) {
        if (annotationEle instanceof Annotated) {
            return (Annotated)annotationEle;
        }
        return new Annotated(annotationEle);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination) {
        return AnnoKit.getAnnotations(annotationEle, isToCombination, (Predicate<Annotation>)null);
    }

    public static <T> T[] getCombinationAnnotations(AnnotatedElement annotationEle, Class<T> annotationType) {
        return AnnoKit.getAnnotations(annotationEle, true, annotationType);
    }

    public static <T> T[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Class<T> annotationType) {
        Annotation[] annotations = AnnoKit.getAnnotations(annotationEle, isToCombination, (Annotation annotation) -> null == annotationType || annotationType.isAssignableFrom(annotation.getClass()));
        T[] result = ArrayKit.newArray(annotationType, annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i];
        }
        return result;
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Predicate<Annotation> predicate) {
        if (null == annotationEle) {
            return null;
        }
        if (isToCombination) {
            if (null == predicate) {
                return AnnoKit.toCombination(annotationEle).getAnnotations();
            }
            return Annotated.of(annotationEle, predicate).getAnnotations();
        }
        Annotation[] result = annotationEle.getAnnotations();
        if (null == predicate) {
            return result;
        }
        return ArrayKit.filter(result, predicate::test);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotationEle, Class<A> annotationType) {
        return null == annotationEle ? null : (A)AnnoKit.toCombination(annotationEle).getAnnotation(annotationType);
    }

    public static boolean hasAnnotation(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return null != AnnoKit.getAnnotation(annotationEle, annotationType);
    }

    public static <A extends Annotation, R> R getAnnotationValue(AnnotatedElement annotationEle, XFunction<A, R> propertyName) {
        if (propertyName == null) {
            return null;
        }
        LambdaKit.Info lambda = LambdaKit.resolve(propertyName);
        String instantiatedMethodType = lambda.getLambda().getInstantiatedMethodType();
        Class annotationClass = ClassKit.loadClass(StringKit.sub(instantiatedMethodType, 2, StringKit.indexOf(instantiatedMethodType, ';')));
        return (R)AnnoKit.getAnnotationValue(annotationEle, annotationClass, lambda.getLambda().getImplMethodName());
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return AnnoKit.getAnnotationValue(annotationEle, annotationType, "value");
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType, String propertyName) {
        Annotation annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method method = ReflectKit.getMethodOfObject(annotation, propertyName, new Object[0]);
        if (null == method) {
            return null;
        }
        return ReflectKit.invoke((Object)annotation, method, new Object[0]);
    }

    public static Map<String, Object> getAnnotationValueMap(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        Annotation annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method[] methods = ReflectKit.getMethods(annotationType, t -> {
            if (ArrayKit.isEmpty(t.getParameterTypes())) {
                String name = t.getName();
                return false == "hashCode".equals(name) && false == "toString".equals(name) && false == "annotationType".equals(name);
            }
            return false;
        });
        HashMap<String, Object> result = new HashMap<String, Object>(methods.length, 1.0f);
        for (Method method : methods) {
            result.put(method.getName(), ReflectKit.invoke((Object)annotation, method, new Object[0]));
        }
        return result;
    }

    public static RetentionPolicy getRetentionPolicy(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        if (null == retention) {
            return RetentionPolicy.CLASS;
        }
        return retention.value();
    }

    public static ElementType[] getTargetType(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (null == target) {
            return new ElementType[]{ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE, ElementType.ANNOTATION_TYPE, ElementType.PACKAGE};
        }
        return target.value();
    }

    public static boolean isDocumented(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Documented.class);
    }

    public static boolean isInherited(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    public static void setValue(Annotation annotation, String annotationField, Object value) {
        Map memberValues = (Map)ReflectKit.getFieldValue((Object)Proxy.getInvocationHandler(annotation), "memberValues");
        memberValues.put(annotationField, value);
    }

    public static <T extends Annotation> T getAlias(AnnotatedElement annotationEle, Class<T> annotationType) {
        T annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new AnnoProxy<T>(annotation)));
    }

    public static <T extends Annotation> T getSynthesis(Annotation annotation, Class<T> annotationType) {
        return Synthetic.of(annotation).getAnnotation(annotationType);
    }

    public static <T extends Annotation> List<T> getAllSynthesis(AnnotatedElement annotatedEle, Class<T> annotationType) {
        AnnotationScanner[] scanners = new AnnotationScanner[]{new MetaScanner(), new TypeScanner(), new MethodScanner(), new FieldScanner()};
        return AnnotationScanner.scanByAnySupported(annotatedEle, scanners).stream().map(annotation -> AnnoKit.getSynthesis(annotation, annotationType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Annotation> scanMetaAnnotation(Class<? extends Annotation> annotationType) {
        return new MetaScanner().getIfSupport(annotationType);
    }

    public static List<Annotation> scanClass(Class<?> targetClass) {
        return new TypeScanner().getIfSupport(targetClass);
    }

    public static List<Annotation> scanMethod(Method method) {
        return new MethodScanner(true).getIfSupport(method);
    }

    public static boolean isAttributeMethod(Method method) {
        return method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE;
    }

    public static Map<String, Method> getAttributeMethods(Class<? extends Annotation> annotationType) {
        Map<String, Method> attributeMethods = Stream.of(annotationType.getDeclaredMethods()).filter(AnnoKit::isAttributeMethod).collect(Collectors.toMap(Method::getName, Function.identity()));
        attributeMethods.forEach((methodName, method) -> {
            String alias = Optional.ofNullable(method.getAnnotation(Alias.class)).map(Alias::value).orElse(null);
            if (ObjectKit.isNull(alias)) {
                return;
            }
            Assert.isTrue(attributeMethods.containsKey(alias), "No method for alias: [{}]", alias);
            Method aliasAttributeMethod = (Method)attributeMethods.get(alias);
            Assert.isTrue(ObjectKit.isNull(aliasAttributeMethod) || ClassKit.isAssignable(method.getReturnType(), aliasAttributeMethod.getReturnType()), "Return type of the alias method [{}] is inconsistent with the original [{}]", aliasAttributeMethod.getClass(), method.getParameterTypes());
            attributeMethods.put((String)methodName, aliasAttributeMethod);
        });
        return attributeMethods;
    }
}

