/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.provider.AESProvider;
import org.aoju.bus.crypto.provider.DESProvider;
import org.aoju.bus.crypto.provider.RC4Provider;
import org.aoju.bus.crypto.provider.RSAProvider;
import org.aoju.bus.crypto.provider.SM2Provider;
import org.aoju.bus.crypto.provider.SM4Provider;

public final class Registry {
    private static Map<String, Provider> ALGORITHM_CACHE = new ConcurrentHashMap<String, Provider>();

    public static void register(String name, Provider object) {
        if (ALGORITHM_CACHE.containsKey(name)) {
            throw new InternalException("Repeat registration of components with the same name\uff1a" + name);
        }
        Class<?> clazz = object.getClass();
        if (ALGORITHM_CACHE.containsKey(clazz.getSimpleName())) {
            throw new InternalException("Repeat registration of components with the same name\uff1a" + clazz);
        }
        ALGORITHM_CACHE.putIfAbsent(name, object);
    }

    public static Provider require(String name) {
        Provider object = ALGORITHM_CACHE.get(name);
        if (ObjectKit.isEmpty(object)) {
            throw new IllegalArgumentException("None provider be found!, type:" + name);
        }
        return object;
    }

    public boolean contains(String name) {
        return ALGORITHM_CACHE.containsKey(name);
    }

    static {
        Registry.register(Algorithm.AES.getValue(), new AESProvider());
        Registry.register(Algorithm.DES.getValue(), new DESProvider());
        Registry.register(Algorithm.RC4.getValue(), new RC4Provider());
        Registry.register(Algorithm.RSA.getValue(), new RSAProvider());
        Registry.register(Algorithm.SM2.getValue(), new SM2Provider());
        Registry.register(Algorithm.SM4.getValue(), new SM4Provider());
    }
}

