/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.function.Predicate;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ftp.AbstractFtp;
import org.aoju.bus.extra.ftp.FtpConfig;
import org.aoju.bus.extra.ssh.JSchKit;

public class Sftp
extends AbstractFtp {
    private Session session;
    private ChannelSftp channel;

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, charset));
    }

    public Sftp(FtpConfig config) {
        this(config, true);
    }

    public Sftp(FtpConfig config, boolean init) {
        super(config);
        if (init) {
            this.init(config);
        }
    }

    public Sftp(Session session) {
        this(session, DEFAULT_CHARSET);
    }

    public Sftp(Session session, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        this.init(session, charset);
    }

    public Sftp(ChannelSftp channel, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        this.init(channel, charset);
    }

    public void init(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this.init(JSchKit.getSession(sshHost, sshPort, sshUser, sshPass), charset);
    }

    public void init() {
        this.init(this.ftpConfig);
    }

    public void init(FtpConfig config) {
        this.init(config.getHost(), config.getPort(), config.getUser(), config.getPassword(), config.getCharset());
    }

    public void init(Session session, Charset charset) {
        this.session = session;
        this.init(JSchKit.openSftp(session, (int)this.ftpConfig.getConnectionTimeout()), charset);
    }

    public void init(ChannelSftp channel, Charset charset) {
        this.ftpConfig.setCharset(charset);
        try {
            channel.setFilenameEncoding(charset.toString());
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        this.channel = channel;
    }

    @Override
    public Sftp reconnectIfTimeout() {
        if (StringKit.isBlank(this.ftpConfig.getHost())) {
            throw new InternalException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (InternalException e) {
            this.close();
            this.init();
        }
        return this;
    }

    public ChannelSftp getClient() {
        return this.channel;
    }

    @Override
    public String pwd() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
    }

    public String home() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return this.ls(path, null);
    }

    public List<String> lsDirs(String path) {
        return this.ls(path, t -> t.getAttrs().isDir());
    }

    public List<String> lsFiles(String path) {
        return this.ls(path, t -> false == t.getAttrs().isDir());
    }

    public List<String> ls(String path, Predicate<ChannelSftp.LsEntry> filter) {
        ArrayList<String> fileNames;
        block2: {
            fileNames = new ArrayList<String>();
            try {
                this.channel.ls(path, entry -> {
                    String fileName = entry.getFilename();
                    if (!(StringKit.equals(".", fileName) || StringKit.equals("..", fileName) || null != filter && !filter.test(entry))) {
                        fileNames.add(entry.getFilename());
                    }
                    return 0;
                });
            }
            catch (SftpException e) {
                if (StringKit.startWithIgnoreCase(e.getMessage(), "No such file")) break block2;
                throw new InternalException(e);
            }
        }
        return fileNames;
    }

    @Override
    public boolean mkdir(String dir) {
        if (this.isDir(dir)) {
            return true;
        }
        try {
            this.channel.mkdir(dir);
            return true;
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public boolean isDir(String dir) {
        SftpATTRS sftpATTRS;
        try {
            sftpATTRS = this.channel.stat(dir);
        }
        catch (SftpException e) {
            String msg = e.getMessage();
            if (StringKit.containsAnyIgnoreCase(msg, "No such file", "does not exist")) {
                return false;
            }
            throw new InternalException(e);
        }
        return sftpATTRS.isDir();
    }

    @Override
    public synchronized boolean cd(String directory) {
        if (StringKit.isBlank(directory)) {
            return true;
        }
        try {
            this.channel.cd(directory.replace('\\', '/'));
            return true;
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public boolean delFile(String filePath) {
        try {
            this.channel.rm(filePath);
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        return true;
    }

    @Override
    public boolean delDir(String dirPath) {
        Vector list;
        if (!this.cd(dirPath)) {
            return false;
        }
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (StringKit.equals(fileName, ".") || StringKit.equals(fileName, "..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.cd("..")) {
            return false;
        }
        try {
            this.channel.rmdir(dirPath);
            return true;
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        this.put(FileKit.getAbsolutePath(file), destPath);
        return true;
    }

    public void upload(File file, String remotePath) {
        if (!FileKit.exists(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File fileItem : files) {
                if (fileItem.isDirectory()) {
                    String mkdir = FileKit.normalize(remotePath + "/" + fileItem.getName());
                    this.upload(fileItem, mkdir);
                    continue;
                }
                this.upload(fileItem, remotePath);
            }
        } else {
            this.mkDirs(remotePath);
            this.upload(remotePath, file);
        }
    }

    public Sftp put(String srcFilePath, String destPath) {
        return this.put(srcFilePath, destPath, Mode.OVERWRITE);
    }

    public Sftp put(String srcFilePath, String destPath, Mode mode) {
        return this.put(srcFilePath, destPath, null, mode);
    }

    public Sftp put(String srcFilePath, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            this.channel.put(srcFilePath, destPath, monitor, mode.ordinal());
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        return this;
    }

    public Sftp put(InputStream srcStream, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            this.channel.put(srcStream, destPath, monitor, mode.ordinal());
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        return this;
    }

    @Override
    public void download(String src, File dest) {
        this.get(src, FileKit.getAbsolutePath(dest));
    }

    @Override
    public void download(String source, String dest) {
        try {
            Vector fileAndFolderList = this.channel.ls(source);
            for (ChannelSftp.LsEntry item : fileAndFolderList) {
                String sourcePathPathFile = source + "/" + item.getFilename();
                String destinationPathFile = dest + "/" + item.getFilename();
                if (!item.getAttrs().isDir()) {
                    if (FileKit.exists(destinationPathFile) && (long)item.getAttrs().getMTime() <= FileKit.lastModifiedTime(destinationPathFile).getTime() / 1000L) continue;
                    this.channel.get(sourcePathPathFile, destinationPathFile);
                    continue;
                }
                if (".".equals(item.getFilename()) || "..".equals(item.getFilename())) continue;
                FileKit.mkdir(destinationPathFile);
                this.download(sourcePathPathFile, destinationPathFile);
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
    }

    public void download(String src, OutputStream out) {
        this.get(src, out);
    }

    public boolean upload(String destPath, String fileName, InputStream fileStream) {
        destPath = StringKit.addSuffixIfNot((CharSequence)destPath, "/") + StringKit.removePrefix(fileName, "/");
        this.put(fileStream, (String)destPath, null, Mode.OVERWRITE);
        return true;
    }

    public Sftp get(String src, String dest) {
        try {
            this.channel.get(src, dest);
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        return this;
    }

    public Sftp get(String src, OutputStream out) {
        try {
            this.channel.get(src, out);
        }
        catch (SftpException e) {
            throw new InternalException(e);
        }
        return this;
    }

    @Override
    public void close() {
        JSchKit.close((Channel)this.channel);
        JSchKit.close(this.session);
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

