/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.filter;

import java.nio.charset.Charset;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.logger.Logger;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=0x7FFFFFFD)
public class FormatFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Context context = Context.get(exchange);
        if (Context.Format.xml.equals((Object)context.getFormat())) {
            exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
        }
        return chain.filter(exchange);
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        final Context context = Context.get(exchange);
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                Flux flux = Flux.from(body);
                return super.writeWith((Publisher)DataBufferUtils.join((Publisher)flux).map(dataBuffer -> {
                    exchange.getResponse().getHeaders().setContentType(context.getFormat().getMediaType());
                    String bodyString = Charset.defaultCharset().decode(dataBuffer.asByteBuffer()).toString();
                    DataBufferUtils.release((DataBuffer)dataBuffer);
                    Message message = JsonKit.toPojo(bodyString, Message.class);
                    String formatBody = context.getFormat().getProvider().serialize(message);
                    if (Logger.isTrace()) {
                        Logger.trace("traceId:{},resp <= {}", exchange.getLogPrefix(), formatBody);
                    }
                    return this.bufferFactory().wrap(formatBody.getBytes());
                }));
            }
        };
    }
}

