/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quartet;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractBaseboard;
import org.aoju.bus.health.linux.drivers.Sysfs;
import org.aoju.bus.health.linux.drivers.proc.CpuInfo;

@Immutable
final class LinuxBaseboard
extends AbstractBaseboard {
    private final Supplier<Quartet<String, String, String, String>> manufacturerModelVersionSerial = Memoize.memoize(CpuInfo::queryBoardInfo);
    private final Supplier<String> manufacturer = Memoize.memoize(this::queryManufacturer);
    private final Supplier<String> model = Memoize.memoize(this::queryModel);
    private final Supplier<String> version = Memoize.memoize(this::queryVersion);
    private final Supplier<String> serialNumber = Memoize.memoize(this::querySerialNumber);

    LinuxBaseboard() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    private String queryManufacturer() {
        String result = Sysfs.queryBoardVendor();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getA()) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryModel() {
        String result = Sysfs.queryBoardModel();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getB()) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryVersion() {
        String result = null;
        result = Sysfs.queryBoardVersion();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getC()) == null) {
            return "unknown";
        }
        return result;
    }

    private String querySerialNumber() {
        String result = Sysfs.queryBoardSerial();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getD()) == null) {
            return "unknown";
        }
        return result;
    }
}

