/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Formats;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.ByRef;
import org.aoju.bus.health.builtin.Struct;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.mac.SysctlKit;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class MacCentralProcessor
extends AbstractCentralProcessor {
    private static final int ARM_CPUTYPE = 0x100000C;
    private static final int M1_CPUFAMILY = 458787763;
    private static final int M2_CPUFAMILY = -634136515;
    private static final long DEFAULT_FREQUENCY = 2400000000L;
    private final Supplier<String> vendor = Memoize.memoize(MacCentralProcessor::platformExpert);
    private final boolean isArmCpu = this.isArmCpu();
    private long performanceCoreFrequency = 2400000000L;
    private long efficiencyCoreFrequency = 2400000000L;

    private static String platformExpert() {
        String manufacturer = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            platformExpert.release();
        }
        return StringKit.isBlank(manufacturer) ? "Apple Inc." : manufacturer;
    }

    private static Map<Integer, String> queryCompatibleStrings() {
        HashMap<Integer, String> compatibleStrMap = new HashMap<Integer, String>();
        IOKit.IOIterator iter = IOKitUtil.getMatchingServices((String)"IOPlatformDevice");
        if (iter != null) {
            IOKit.IORegistryEntry cpu = iter.next();
            while (cpu != null) {
                if (cpu.getName().toLowerCase().startsWith("cpu")) {
                    int procId = Builder.getFirstIntValue(cpu.getName());
                    byte[] data = cpu.getByteArrayProperty("compatible");
                    if (data != null) {
                        compatibleStrMap.put(procId, new String(data, StandardCharsets.UTF_8).replace('\u0000', ' '));
                    }
                }
                cpu.release();
                cpu = iter.next();
            }
            iter.release();
        }
        return compatibleStrMap;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        try (Struct.CloseableHostCpuLoadInfo cpuLoadInfo = new Struct.CloseableHostCpuLoadInfo();
             ByRef.CloseableIntByReference size = new ByRef.CloseableIntByReference(cpuLoadInfo.size());){
            if (0 != SystemB.INSTANCE.host_statistics(machPort, 3, (Structure)cpuLoadInfo, (IntByReference)size)) {
                Logger.error("Failed to get System CPU ticks. Error code: {} ", Native.getLastError());
                long[] lArray = ticks;
                return lArray;
            }
            ticks[CentralProcessor.TickType.USER.getIndex()] = cpuLoadInfo.cpu_ticks[0];
            ticks[CentralProcessor.TickType.NICE.getIndex()] = cpuLoadInfo.cpu_ticks[3];
            ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpuLoadInfo.cpu_ticks[1];
            ticks[CentralProcessor.TickType.IDLE.getIndex()] = cpuLoadInfo.cpu_ticks[2];
        }
        return ticks;
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String processorID;
        String cpuFamily;
        String cpuModel;
        String cpuStepping;
        String cpuVendor;
        String cpuName = SysctlKit.sysctl("machdep.cpu.brand_string", "");
        if (cpuName.startsWith("Apple")) {
            int family;
            int type;
            cpuVendor = this.vendor.get();
            cpuStepping = "0";
            cpuModel = "0";
            if (this.isArmCpu) {
                type = 0x100000C;
                family = cpuName.contains("M2") ? -634136515 : 458787763;
            } else {
                type = SysctlKit.sysctl("hw.cputype", 0);
                family = SysctlKit.sysctl("hw.cpufamily", 0);
            }
            cpuFamily = String.format("0x%08x", family);
            processorID = String.format("%08x%08x", type, family);
        } else {
            cpuVendor = SysctlKit.sysctl("machdep.cpu.vendor", "");
            int i = SysctlKit.sysctl("machdep.cpu.stepping", -1);
            cpuStepping = i < 0 ? "" : Integer.toString(i);
            i = SysctlKit.sysctl("machdep.cpu.model", -1);
            cpuModel = i < 0 ? "" : Integer.toString(i);
            i = SysctlKit.sysctl("machdep.cpu.family", -1);
            cpuFamily = i < 0 ? "" : Integer.toString(i);
            long processorIdBits = 0L;
            processorIdBits |= (long)SysctlKit.sysctl("machdep.cpu.signature", 0);
            processorID = String.format("%016x", processorIdBits |= (SysctlKit.sysctl("machdep.cpu.feature_bits", 0L) & 0xFFFFFFFFFFFFFFFFL) << 32);
        }
        if (this.isArmCpu) {
            this.calculateNominalFrequencies();
        }
        long cpuFreq = this.isArmCpu ? this.performanceCoreFrequency : SysctlKit.sysctl("hw.cpufrequency", 0L);
        boolean cpu64bit = SysctlKit.sysctl("hw.cpu64bit_capable", 0) != 0;
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    @Override
    protected Triple<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        int logicalProcessorCount = SysctlKit.sysctl("hw.logicalcpu", 1);
        int physicalProcessorCount = SysctlKit.sysctl("hw.physicalcpu", 1);
        int physicalPackageCount = SysctlKit.sysctl("hw.packages", 1);
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>(logicalProcessorCount);
        HashSet<Integer> pkgCoreKeys = new HashSet<Integer>();
        for (int i = 0; i < logicalProcessorCount; ++i) {
            int coreId = i * physicalProcessorCount / logicalProcessorCount;
            int pkgId = i * physicalPackageCount / logicalProcessorCount;
            logProcs.add(new CentralProcessor.LogicalProcessor(i, coreId, pkgId));
            pkgCoreKeys.add((pkgId << 16) + coreId);
        }
        Map<Integer, String> compatMap = MacCentralProcessor.queryCompatibleStrings();
        int perflevels = SysctlKit.sysctl("hw.nperflevels", 1);
        List physProcs = pkgCoreKeys.stream().sorted().map(k -> {
            String compat = compatMap.getOrDefault(k, "").toLowerCase();
            int efficiency = 0;
            if (compat.contains("firestorm") || compat.contains("avalanche")) {
                efficiency = 1;
            }
            return new CentralProcessor.PhysicalProcessor(k >> 16, (int)(k & 0xFFFF), efficiency, compat);
        }).collect(Collectors.toList());
        List<CentralProcessor.ProcessorCache> caches = MacCentralProcessor.orderedProcCaches(this.getCacheValues(perflevels));
        return Triple.of(logProcs, physProcs, caches);
    }

    private Set<CentralProcessor.ProcessorCache> getCacheValues(int perflevels) {
        int linesize = (int)SysctlKit.sysctl("hw.cachelinesize", 0L);
        int l1associativity = SysctlKit.sysctl("machdep.cpu.cache.L1_associativity", 0, false);
        int l2associativity = SysctlKit.sysctl("machdep.cpu.cache.L2_associativity", 0, false);
        HashSet<CentralProcessor.ProcessorCache> caches = new HashSet<CentralProcessor.ProcessorCache>();
        for (int i = 0; i < perflevels; ++i) {
            int size = SysctlKit.sysctl("hw.perflevel" + i + ".l1icachesize", 0, false);
            if (size > 0) {
                caches.add(new CentralProcessor.ProcessorCache(1, l1associativity, linesize, (long)size, CentralProcessor.ProcessorCache.Type.INSTRUCTION));
            }
            if ((size = SysctlKit.sysctl("hw.perflevel" + i + ".l1dcachesize", 0, false)) > 0) {
                caches.add(new CentralProcessor.ProcessorCache(1, l1associativity, linesize, (long)size, CentralProcessor.ProcessorCache.Type.DATA));
            }
            if ((size = SysctlKit.sysctl("hw.perflevel" + i + ".l2cachesize", 0, false)) > 0) {
                caches.add(new CentralProcessor.ProcessorCache(2, l2associativity, linesize, (long)size, CentralProcessor.ProcessorCache.Type.UNIFIED));
            }
            if ((size = SysctlKit.sysctl("hw.perflevel" + i + ".l3cachesize", 0, false)) <= 0) continue;
            caches.add(new CentralProcessor.ProcessorCache(3, 0, linesize, (long)size, CentralProcessor.ProcessorCache.Type.UNIFIED));
        }
        return caches;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = SystemB.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            Arrays.fill(average, -1.0);
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        try (ByRef.CloseableIntByReference procCount = new ByRef.CloseableIntByReference();
             ByRef.CloseablePointerByReference procCpuLoadInfo = new ByRef.CloseablePointerByReference();
             ByRef.CloseableIntByReference procInfoCount = new ByRef.CloseableIntByReference();){
            if (0 != SystemB.INSTANCE.host_processor_info(machPort, 2, (IntByReference)procCount, (PointerByReference)procCpuLoadInfo, (IntByReference)procInfoCount)) {
                Logger.error("Failed to update CPU Load. Error code: {}", Native.getLastError());
                long[][] lArray = ticks;
                return lArray;
            }
            int[] cpuTicks = procCpuLoadInfo.getValue().getIntArray(0L, procInfoCount.getValue());
            for (int cpu = 0; cpu < procCount.getValue(); ++cpu) {
                int offset = cpu * 4;
                ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = Formats.getUnsignedInt(cpuTicks[offset + 0]);
                ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = Formats.getUnsignedInt(cpuTicks[offset + 3]);
                ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = Formats.getUnsignedInt(cpuTicks[offset + 1]);
                ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = Formats.getUnsignedInt(cpuTicks[offset + 2]);
            }
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        return 0L;
    }

    @Override
    public long queryInterrupts() {
        return 0L;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (this.isArmCpu) {
            HashMap physFreqMap = new HashMap();
            this.getPhysicalProcessors().stream().forEach(p -> physFreqMap.put(p.getPhysicalProcessorNumber(), p.getEfficiency() > 0 ? this.performanceCoreFrequency : this.efficiencyCoreFrequency));
            return this.getLogicalProcessors().stream().map(CentralProcessor.LogicalProcessor::getPhysicalProcessorNumber).map(p -> physFreqMap.getOrDefault(p, this.performanceCoreFrequency)).mapToLong(f -> f).toArray();
        }
        return new long[]{this.getProcessorIdentifier().getVendorFreq()};
    }

    @Override
    public long queryMaxFreq() {
        if (this.isArmCpu) {
            return this.performanceCoreFrequency;
        }
        return SysctlKit.sysctl("hw.cpufrequency_max", this.getProcessorIdentifier().getVendorFreq());
    }

    private boolean isArmCpu() {
        return this.getPhysicalProcessors().stream().map(CentralProcessor.PhysicalProcessor::getEfficiency).anyMatch(e -> e > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateNominalFrequencies() {
        IOKit.IOIterator iter = IOKitUtil.getMatchingServices((String)"AppleARMIODevice");
        if (iter != null) {
            try {
                IOKit.IORegistryEntry device = iter.next();
                try {
                    while (true) {
                        if (device != null) {
                            if ("pmgr".equalsIgnoreCase(device.getName())) {
                                this.performanceCoreFrequency = this.getMaxFreqFromByteArray(device.getByteArrayProperty("voltage-states5-sram"));
                                this.efficiencyCoreFrequency = this.getMaxFreqFromByteArray(device.getByteArrayProperty("voltage-states1-sram"));
                                return;
                            }
                            device.release();
                            device = iter.next();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (device != null) {
                        device.release();
                    }
                }
            }
            finally {
                iter.release();
            }
        }
    }

    private long getMaxFreqFromByteArray(byte[] data) {
        if (data != null && data.length >= 8) {
            byte[] freqData = Arrays.copyOfRange(data, data.length - 8, data.length - 4);
            return Builder.byteArrayToLong(freqData, 4, false);
        }
        return 2400000000L;
    }
}

