/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.ByRef;
import org.aoju.bus.health.unix.FreeBsdLibc;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class BsdSysctlKit {
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    public static int sysctl(String name, int def) {
        int intSize = FreeBsdLibc.INT_SIZE;
        try (Memory p = new Memory((long)intSize);){
            ByRef.CloseableSizeTByReference size;
            block12: {
                size = new ByRef.CloseableSizeTByReference(intSize);
                try {
                    if (0 == FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) break block12;
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    int n = def;
                    size.close();
                    return n;
                }
                catch (Throwable throwable) {
                    try {
                        size.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n = p.getInt(0L);
            size.close();
            return n;
        }
    }

    public static long sysctl(String name, long def) {
        int uint64Size = FreeBsdLibc.UINT64_SIZE;
        try (Memory p = new Memory((long)uint64Size);){
            ByRef.CloseableSizeTByReference size;
            block12: {
                size = new ByRef.CloseableSizeTByReference(uint64Size);
                try {
                    if (0 == FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) break block12;
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    long l = def;
                    size.close();
                    return l;
                }
                catch (Throwable throwable) {
                    try {
                        size.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l = p.getLong(0L);
            size.close();
            return l;
        }
    }

    public static String sysctl(String name, String def) {
        try (ByRef.CloseableSizeTByReference size = new ByRef.CloseableSizeTByReference();){
            Memory p;
            block14: {
                String string;
                if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    String string2 = def;
                    return string2;
                }
                p = new Memory(size.longValue() + 1L);
                try {
                    if (0 == FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) break block14;
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    string = def;
                }
                catch (Throwable throwable) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                p.close();
                return string;
            }
            String string = p.getString(0L);
            p.close();
            return string;
        }
    }

    public static boolean sysctl(String name, Structure struct) {
        try (ByRef.CloseableSizeTByReference size = new ByRef.CloseableSizeTByReference(struct.size());){
            if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, struct.getPointer(), size, null, LibCAPI.size_t.ZERO)) {
                Logger.error(SYSCTL_FAIL, name, Native.getLastError());
                boolean bl = false;
                return bl;
            }
        }
        struct.read();
        return true;
    }

    public static Memory sysctl(String name) {
        try (ByRef.CloseableSizeTByReference size = new ByRef.CloseableSizeTByReference();){
            if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
                Logger.error(SYSCTL_FAIL, name, Native.getLastError());
                Memory memory = null;
                return memory;
            }
            Memory m = new Memory(size.longValue());
            if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)m, size, null, LibCAPI.size_t.ZERO)) {
                Logger.error(SYSCTL_FAIL, name, Native.getLastError());
                m.close();
                Memory memory = null;
                return memory;
            }
            Memory memory = m;
            return memory;
        }
    }
}

