/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.net.Proxy;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.UnoUrl;

public class RequestLine {
    private RequestLine() {
    }

    public static String get(Request request, Proxy.Type proxyType) {
        StringBuilder result = new StringBuilder();
        result.append(request.method());
        result.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result.append(request.url());
        } else {
            result.append(RequestLine.requestPath(request.url()));
        }
        result.append(" HTTP/1.1");
        return result.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(UnoUrl url) {
        String path = url.encodedPath();
        String query = url.encodedQuery();
        return null != query ? path + "?" + query : path;
    }
}

