/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.secure;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Route;
import org.aoju.bus.http.UnoUrl;
import org.aoju.bus.http.secure.Authenticator;
import org.aoju.bus.http.secure.Challenge;
import org.aoju.bus.http.secure.Credentials;

public class NetAuthenticator
implements Authenticator {
    @Override
    public Request authenticate(Route route, Response response) throws IOException {
        List<Challenge> challenges = response.challenges();
        Request request = response.request();
        UnoUrl url = request.url();
        boolean proxyAuthorization = response.code() == 407;
        Proxy proxy = route.proxy();
        int size = challenges.size();
        for (int i = 0; i < size; ++i) {
            PasswordAuthentication auth;
            Challenge challenge = challenges.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            if (proxyAuthorization) {
                InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
                auth = java.net.Authenticator.requestPasswordAuthentication(proxyAddress.getHostName(), this.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.PROXY);
            } else {
                auth = java.net.Authenticator.requestPasswordAuthentication(url.host(), this.getConnectToInetAddress(proxy, url), url.port(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.SERVER);
            }
            if (null == auth) continue;
            String credential = Credentials.basic(auth.getUserName(), new String(auth.getPassword()), challenge.charset());
            return request.newBuilder().header(proxyAuthorization ? "Proxy-Authenticate" : "Authorization", credential).build();
        }
        return null;
    }

    private InetAddress getConnectToInetAddress(Proxy proxy, UnoUrl url) throws IOException {
        return null != proxy && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.host());
    }
}

